
package sgp;

public class AverageLinearIntercept extends LinearIntercept
{
	AverageLinearAnalyser analyser = null;
	
	/**
	 * Constructor for AverageLinearIntercept.
	 * @param tRadius
	 */
	public AverageLinearIntercept(AverageLinearAnalyser theAnalyser, double tRadius)
	{
		super(tRadius);

		analyser = theAnalyser;
	}

	/**
	 * Constructor for AverageLinearIntercept.
	 */
	public AverageLinearIntercept(AverageLinearAnalyser theAnalyser)
	{
		super();
		
		analyser = theAnalyser;
	}
	
	public void calculate
		(
			double xb,
			double yb,
			double xt,
			double yt,
			double tHeading,
			double vt,
			double bPower,
			double angularVelocity_deg_per_sec
		)
	{
		//get the position N samples ago.
		Coordinate oldPosition = analyser.getOldPosition();
		
		double averageHeading;
		double averageVelocity;
		
		if (oldPosition != null)
		{
			//get current position
			Coordinate currentPosition = new Coordinate(xt,yt);		
			averageHeading = oldPosition.headingTo(currentPosition);
			averageVelocity = oldPosition.distanceFrom(currentPosition) / analyser.getOldTimeDifference();
		}
		else
		{
			averageHeading = tHeading;
			averageVelocity = vt;
		}
		
		super.calculate
		(
			xb,
			yb,
			xt,
			yt,
			averageHeading,
			averageVelocity,
			bPower,
			angularVelocity_deg_per_sec
		);
	}

}
