/**
 *	Random moving robot and do not hit wall.
 */

package timmit;
import robocode.*;

class Move{
	private static TimmiT bot;
	private static Enemy en;
	private static double battle_width;
	private static double battle_height;
	private final static double DIST_ENEMY = 366;
	private final static double DIST_WALL = 50;
	private final static double DIST_REMAIN = 3;
	private final static double TURN_REMAIN = 2;
	
	Move(TimmiT owner){
		this.bot = owner;
		battle_width = owner.getBattleFieldWidth();
		battle_height = owner.getBattleFieldHeight();
	}//end construct
	
	protected void do_move(Enemy en){
		this.en = en;
		if(bot.getEnergy()>en.energy && en.energy<3){
			this.hitTarget();
		}else{
			this.littleMoving();
			this.randomMoving();
		}//end
	}//end
	
	private void littleMoving(){									//little moving when distance remaining ~
		if(Math.abs(bot.getDistanceRemaining()) <= DIST_REMAIN){
			double turnAngle = Util.getRelativeRadians(en.bearingRadians + Util.HALF_PI);
			bot.setTurnRightRadians(turnAngle);
			if(Math.abs(bot.getTurnRemaining()) <= TURN_REMAIN){
				bot.setAhead(DIST_REMAIN * 2 * Util.getRandomRator(0.6));
			}//end if
		}//end if
	}//end
	
	private void randomMoving(){			//calculate next point to moving.
		if(en.energy!=en.epEnergy){
			double dist = 200 + 3 * (100 - bot.getEnergy());
			double angle = (Math.PI/2-(en.distance - dist)/(dist - 60)*Math.PI/4)*Util.getRandomRator(0.6);
			double move = en.distance * Util.getDoubleRandom(0.6,0.8) * Math.random() + bot.getHeight();
			double nextX = bot.getX() + Math.sin(en.absoluteBearingRadians + angle) * move;
			double nextY = bot.getY() + Math.cos(en.absoluteBearingRadians + angle) * move;
			nextX = Math.min(this.battle_width - DIST_WALL, Math.max(nextX,DIST_WALL)) * 2 - nextX;
			nextY = Math.min(this.battle_height - DIST_WALL, Math.max(nextY,DIST_WALL)) * 2 - nextY;
			angle = Util.getRelativeRadians(Math.atan2(nextX-bot.getX(),nextY-bot.getY()) - bot.getHeadingRadians());
			move = Util.getRange(bot.getX(),bot.getY(),nextX,nextY);
			if(Math.abs(angle) > Util.HALF_PI){
				angle += Math.PI;
				move = -move;
			}//end if
			bot.setTurnRightRadians(Util.getRelativeRadians(angle));
			bot.setAhead(move);
		}//end if
	}//end
	
	private void hitTarget(){			//moving to hit target bomb.
		bot.setTurnRightRadians(Util.getRelativeRadians(en.bearingRadians));
		bot.setAhead(en.distance + bot.getHeight());
	}//end
	
	private long getMoveTime(double bulletEnergy){		//calculate next time to moving.
		double benergy = Math.min(3,Math.max(0.1,bulletEnergy));
		return (long)(en.distance / (20 - 3 * benergy));
	}//end getmovetime.
	
	private void testMoving(){
		bot.setTurnRightRadians(Util.getRelativeRadians(Util.getDoubleRandom(0,Util.QUARTER_PI)) * Util.getRandomRator(0.6));
		bot.setAhead(en.distance * Util.getDoubleRandom(0.2,0.8) * Util.getRandomRator(0.6));
	}//end test
}