/*
 * Created on 02/03/2004
 * Author: Marcos Machado
 *
 * TDS - Telecommunication Data Systems ltda.                                                   *
 *                                                                        
 * Copyright (C)                                                          
 * This software may not be copied or distributed in any form without the 
 * written permission of TDS - Telecommunication Data Systems ltda.                             *
 */
package axeBots.pilot.navigator;

import axeBots.AxeBot;
import axeBots.Okami;
import axeBots.data.BitRater;
import axeBots.data.SegmentedGFs;
import axeBots.okami.AxeTarget;
import axeBots.okami.AxeVector;
import axeBots.pilot.AxePilot;
import axeBots.pilot.waves.EnemyWave;
import java.awt.geom.*;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.text.NavigationFilter;

public class Course {

	// private final WaveNavigator navigator;
	protected int goodPoints;
	private static int consecutives;
	protected static int chosen;
	protected boolean re;
	protected boolean wallRestricted = false;
	private Point2D.Double pos;
	protected int timeSlack;
	//			tempo ate o muro
	protected int timeToWall;
	//deslocamento maximo
	protected int travelTime;
	protected double desloc;
	//arco da onda
	protected double arc;
	//posiccao no arco
	protected double arcPos;
	//tamanho da fatia de cada gf
	protected double slc;
	//gf linear
	protected double linGF;
	protected double maxLinGF;
	protected int depth;
	private ArrayList lastGFs;
	private static Course courseRe = new Course(true);
	private static Course courseFt = new Course(false);
	private static Course course = null;
	private static long lastChangeTime = 0;
	private static WaveNavigator navigator = null;
	protected static Boolean dangerPts[] = null;
	protected int toDngr = 0;
	private static int lastSet = 0;
	protected static boolean dontStop = false;

	public static void process() {
		if (course == null) {
			return;
		}
		course.compute();
	}

	private void compute() {
		pos = navigator.me.pos();
		//tempo de manobra
		int start = navigator.wave.getDangerStartTime(0, pos);
		this.toDngr = start;
		int end = navigator.wave.getDangerEndTime(0, pos);
		timeSlack = end; //start+(int)(Math.random()*(end-start+1));
		//wave.getDangerStartTime(0,
		// pos);
		//			tempo ate o muro
		timeToWall = surfToWall(re);
		//		travelTime = (timeSlack < timeToWall) ? timeSlack : timeToWall;
		if (timeSlack < timeToWall) {
			travelTime = timeSlack;
			this.wallRestricted = false;
		} else {
			travelTime = timeToWall;
			this.wallRestricted = true;
		}
		//            System.out.println("to wall:" + timeToWall + " timeSlack:"
		//                    + timeSlack + " travelTime:" + travelTime);
		//deslocamento maximo
		desloc = getMaxDesloc(travelTime, re);
		if (navigator.wave.getDir() < 0) {
			desloc *= -1;
		}
		//arco da onda
		arc = navigator.wave.getArcLen(pos);
		//posiccao no arco
		arcPos = navigator.wave.getWaveLinearPos(pos);
		//tamanho da fatia de cada gf
		slc = arc / SegmentedGFs.GF_QT;
		//gf linear
		linGF = navigator.wave.getWaveLinearGF(arc, arcPos);
		linGF = (linGF < 0) ? 0 : (linGF > (SegmentedGFs.GF_QT - 1))
				? SegmentedGFs.GF_QT - 1
				: linGF;
		maxLinGF = navigator.wave.getWaveLinearGF(arc, arcPos + desloc);
		maxLinGF = (maxLinGF < 0) ? 0 : (maxLinGF > (SegmentedGFs.GF_QT - 1))
				? SegmentedGFs.GF_QT - 1
				: maxLinGF;
	}

	public static void traceCourse(WaveNavigator nav) {
		navigator = nav;
		EnemyWave wav = nav.getWave();
		courseFt.compute();
		courseRe.compute();
		System.out.println(courseFt);
		System.out.println(courseRe);
		int maxRe = (int) courseRe.maxLinGF;
		int maxFt = (int) courseFt.maxLinGF;
		int myPos = (int) courseFt.linGF;
		if (!courseFt.wallRestricted && courseRe.wallRestricted) {
			maxRe = myPos;
		} else if (courseFt.wallRestricted && !courseRe.wallRestricted) {
			maxFt = myPos;
		}
		//      granulometria
		consecutives = (int) (25.0 / courseFt.slc); //(int) (39.99 / slc);
		int totalHoles = (int) Math.abs(maxRe - maxFt) + 1;
		int from = 0;
		int to = 0;
		if (maxRe > maxFt) {
			from = maxFt;
			to = maxRe;
		} else {
			from = maxRe;
			to = maxFt;
		}
		System.out.println("wav.getFireTime():" + wav.getFireTime()
				+ " lastChangeTime:" + lastChangeTime + " chosen:" + chosen
				+ " from:" + from + " to:" + to);
		//		if (wav.getFireTime() < lastChangeTime) {
		//			if ((chosen >= from) && (chosen <= to)) {
		//				if (maxRe > maxFt) {
		//					if (chosen >= myPos) {
		//						course = courseRe;
		//					} else {
		//						course = courseFt;
		//					}
		//				} else {
		//					if (chosen <= myPos) {
		//						course = courseRe;
		//					} else {
		//						course = courseFt;
		//					}
		//				}
		//				System.out.println("mantendo curso.");
		//				return;
		//			}
		//		}
		boolean[] dgrs = new boolean[totalHoles];
		//extrai o pior
		//		double worstGF = getWorstGF();
		//		if (!Double.isNaN(worstGF)) {
		//			boolean[] withoutWorst = extractGF(dgrs, from, (int) worstGF,
		//					consecutives);
		//			if (countHoles(withoutWorst) == 0) {
		//				System.out
		//						.println("!!!!!!!!!!!!!!!!! nao consegui extrair o pior.");
		//			} else {
		//				dgrs = withoutWorst;
		//			}
		//		}
		//extrai os ultimos.
		ArrayList lastGFs = EnemyWave.getLastGFs();
		dgrs = extractMe(EnemyWave.countCurrentWaves() , dgrs, from, lastGFs, consecutives);
		DecimalFormat forma = new DecimalFormat("0.00");
		double ptsPerVel = (SegmentedGFs.GF_QT - 1) / (8D * 2D);
		//		for (int i = 0; i < dgrs.length; i++) {
		//			System.out.print(forma
		//					.format(((i + from) - ((SegmentedGFs.GF_QT - 1) / 2D))
		//							/ ptsPerVel)
		//					+ ":" + ((dgrs[i]) ? 1 : 0) + " ");
		//		}
		//		System.out.println();
		totalHoles = countHoles(dgrs);
		int minHoles = (totalHoles / 8);
		if (minHoles == 0) {
			minHoles = 1;
		}
		//retira os pts de perigo;
		dgrs = fillDangerPts(1, 65, from, consecutives, dgrs, minHoles);
		//		for (int i = 0; i < dgrs.length; i++) {
		//			System.out.print(forma
		//					.format(((i + from) - ((SegmentedGFs.GF_QT - 1) / 2D))
		//							/ ptsPerVel)
		//					+ ":" + ((dgrs[i]) ? 1 : 0) + " ");
		//		}
		//		System.out.println();
		//limpa os ultimos visitados
		dgrs = extractMe(30, dgrs, from, lastGFs, consecutives);
		//		for (int i = 0; i < dgrs.length; i++) {
		//			System.out.print(forma
		//					.format(((i + from) - ((SegmentedGFs.GF_QT - 1) / 2D))
		//							/ ptsPerVel)
		//					+ ":" + ((dgrs[i]) ? 1 : 0) + " ");
		//		}
		//		System.out.println();
		chosen = navigator.chooseFuture(dgrs);
		chosen += from;
		int min = 0;
		if (maxRe > maxFt) {
			min = maxFt;
			if (chosen >= myPos) {
				course = courseRe;
			} else {
				course = courseFt;
			}
		} else {
			min = maxRe;
			if (chosen <= myPos) {
				course = courseRe;
			} else {
				course = courseFt;
			}
		}
		dangerPts = new Boolean[SegmentedGFs.GF_QT];
		for (int j = 0; j < dgrs.length; j++) {
			dangerPts[j + min] = new Boolean(dgrs[j]);
		}
		if (course.timeSlack <= course.timeToWall) {
			lastChangeTime = AxeBot.getIt().getTime();
		}
		//seta dont stop
		if (course.wallRestricted) {
			dontStop = false;
		} else {
			dontStop = true;
			if (chosen < myPos) {
				for (int j = chosen; j >= from; j--) {
					if (dgrs[j - from]) {
						dontStop = false;
						break;
					}
				}
			} else {
				for (int j = chosen; j <= to; j++) {
					if (dgrs[j - from]) {
						dontStop = false;
						break;
					}
				}
			}
		}
	}

	//	public void trace() {
	//		compute();
	//		double totalHoles = Math.abs(maxLinGF - linGF) + 1;
	//		int desiredHoles = 2; //(totalHoles > 2) ? 2 : 1;
	//		int availableHoles = 0;
	//		int from = (int) ((linGF > maxLinGF) ? maxLinGF : linGF);
	//		int to = (int) ((linGF < maxLinGF) ? maxLinGF : linGF);
	//		this.lastGFs = EnemyWave.getLastGFs();
	//		depth = 65;
	//		/*
	//		 * System.out.println("consecutives:" + consecutives + " from:" + from
	//		 */
	//		availableHoles = 0;
	//		while ((availableHoles < desiredHoles) && (depth >= 0)) {
	//			//dangerPts= this.setDangerPts(--depth, from, to);
	//			availableHoles = (to - from + 1)
	//					- countDangerPts(--depth, from, to, consecutives);
	//		}
	//		boolean[] dgrs = setDangerPts(depth, from, to, consecutives);
	//		// DecimalFormat forma = new DecimalFormat("0.00");
	//		// double ptsPerVel = (SegmentedGFs.GF_QT - 1) / (8D * 2D);
	//		// System.out.println("re:" + re );
	//		// for (int i = 0; i < dgrs.length; i++) {
	//		// System.out.print(forma
	//		// .format(((i + from) - ((SegmentedGFs.GF_QT - 1) / 2D))
	//		// / ptsPerVel)
	//		// + ":" + ((dgrs[i]) ? 1 : 0) + " ");
	//		// }
	//		// System.out.println();
	//		dgrs = extractMe(30 /* (int)(Math.random()*(4)) */
	//		, dgrs, from, lastGFs, consecutives);
	//		// for (int i = 0; i < dgrs.length; i++) {
	//		// System.out.print(forma
	//		// .format(((i + from) - ((SegmentedGFs.GF_QT - 1) / 2D))
	//		// / ptsPerVel)
	//		// + ":" + ((dgrs[i]) ? 1 : 0) + " ");
	//		// }
	//		// System.out.println();
	//		// for (int i = 0; i < dgrsWithoutMe.length; i++) {
	//		// System.out.print(forma
	//		// .format(((i + from) - ((SegmentedGFs.GF_QT - 1) / 2D))
	//		// / ptsPerVel)
	//		// + ":" + ((dgrsWithoutMe[i]) ? 1 : 0) + " ");
	//		// if (!dgrsWithoutMe[i]) {
	//		// c++;
	//		// }
	//		// }
	//		// System.out.println();
	//		// if (c > 0) {
	//		// dgrs = dgrsWithoutMe;
	//		// }
	//		goodPoints = dgrs.length;
	//		chosen = navigator.chooseFuture(dgrs);
	//		chosen += from; //(linGF < maxLinGF) ? from:to;
	//		/*
	//		 * System.out.println("Choosing. depth:" + depth + " totalHoles:" +
	//		 * totalHoles + " desiredHoles:" + desiredHoles + " availableHoles:" +
	//		 * availableHoles + " from:" + from
	//		 */
	//	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "> Course. " + " re:" + re + " timeSlack:" + timeSlack
				+ " timeToWall:" + timeToWall + " travelTime:" + travelTime
				+ " linGF:" + linGF + " maxLinGF:" + maxLinGF + "\r\n depth:"
				+ depth + " chosen:" + chosen + " consecutives:" + consecutives
				+ " goodPoints:" + goodPoints + " arc:" + arc + " arcPos:"
				+ arcPos + " slc:" + slc;
	}

	/**
	 *  
	 */
	public Course(boolean re) {
		super();
		this.re = re;
	}

	private static boolean[] fillDangerPts(int minDepth, int maxDepth,
			int initGf, int consecutives, boolean dgrs[], int minHoles) {
		int from = initGf;
		int to = initGf + dgrs.length - 1;
		boolean danger[] = new boolean[dgrs.length];
		boolean test[] = new boolean[dgrs.length];
		//copy dgrs into danger
		for (int j = 0; j < danger.length; j++) {
			danger[j] = dgrs[j];
		}
		double dist = navigator.wave.getCenter().distance(navigator.me.pos());
		BitRater rater[] = navigator.gfHolder.getBitRater(dist);
		//        for (int k = maxDepth; k >= minDepth; k--) {
		int k = 0;
		for (k = minDepth; k < maxDepth; k++) {
			//            System.out.println("1:");
			//			copy into test
			for (int j = 0; j < danger.length; j++) {
				test[j] = danger[j];
			}
			//            System.out.println("2:" + rater.length);
			for (int i = 0; i < rater.length; i++) {
				boolean isOn = !rater[i].isEmpty(k);
				if (isOn) {
					//					System.out.println("isOn:" + i);
					if ((i >= from) && (i <= to)) {
						test[i - from] = isOn;
					}
					for (int j = 0; j < consecutives; j++) {
						int pre = i - (j + 1);
						int pos = i + (j + 1);
						if ((pre >= from) && (pre <= to)) {
							test[pre - from] = isOn;
						}
						if ((pos >= from) && (pos <= to)) {
							test[pos - from] = isOn;
						}
					}
				}
			}
			//            System.out.println("3:");
			int c = countHoles(test);
			//            System.out.println("k:" + k + " c:" + c);
			if (c < minHoles) {
				System.out.println("k:" + k + " c:" + c);
				break;
			}
			//			copy test into danger
			for (int j = 0; j < danger.length; j++) {
				danger[j] = test[j];
			}
		}
		System.out
				.println("fillDangerPts depth:" + k + " minDepth:" + minDepth
						+ " maxDepth:" + maxDepth + " consecutives:"
						+ consecutives + " dgrs.length:" + dgrs.length
						+ " from:" + from + " to:" + to);
		return danger;
	}

	private static int countHoles(boolean dgrs[]) {
		int c = 0;
		for (int i = 0; i < dgrs.length; i++) {
			if (!dgrs[i]) {
				c++;
			}
		}
		return c;
	}

	private static int countDangerPts(int depth, int from, int to,
			int consecutives) {
		boolean[] dgrs = setDangerPts(depth, from, to, consecutives);
		int tot = 0;
		for (int i = 0; i < dgrs.length; i++) {
			//        	System.out.print(" "+i+":"+(dgrs[i]));
			tot += (dgrs[i]) ? 1 : 0;
		}
		//		System.out.println();
		return tot;
	}

	private static boolean[] setDangerPts(int depth, int from, int to,
			int consecutives) {
		boolean danger[] = new boolean[to - from + 1];
		double dist = navigator.wave.getCenter().distance(navigator.me.pos());
		BitRater rater[] = navigator.gfHolder.getBitRater(dist);
		for (int i = 0; i < rater.length; i++) {
			boolean isOn = !rater[i].isEmpty(depth);
			if (isOn) {
				if ((i >= from) && (i <= to)) {
					danger[i - from] = isOn;
				}
				for (int j = 0; j < consecutives; j++) {
					int pre = i - (j + 1);
					int pos = i + (j + 1);
					if ((pre >= from) && (pre <= to)) {
						danger[pre - from] = isOn;
					}
					if ((pos >= from) && (pos <= to)) {
						danger[pos - from] = isOn;
					}
				}
			}
		}
		return danger;
	}

	/**
	 * @param depth2
	 * @param dgrs
	 * @param lastGf2
	 * @param consecutives2
	 * @return
	 */
	private static boolean[] extractMe(int depth, boolean[] dgrs, int initGF,
			ArrayList myGfs, int consecutives) {
		if (myGfs == null || myGfs.isEmpty()) {
			return dgrs;
		}
		boolean danger[] = new boolean[dgrs.length];
		//copy dgrs into danger
		for (int i = 0; i < danger.length; i++) {
			danger[i] = dgrs[i];
		}
		boolean test[] = new boolean[danger.length];
		for (int j = myGfs.size() - 1; j >= 0; j--) {
			if (depth-- <= 0) {
				break;
			}
			int myGf = ((Integer) myGfs.get(j)).intValue() - initGF;
			if(countHits(myGf , consecutives)==0){
				continue;
			}
			int c = 0;
			//copy into test
			for (int i = 0; i < danger.length; i++) {
				test[i] = danger[i];
			}
			for (int i = 0; i < test.length; i++) {
				if ((i <= (myGf + consecutives))
						&& (i >= (myGf - consecutives))) {
					test[i] = true;
				}
				if (!test[i]) {
					c++;
				}
			}
			if (c == 0) {
				break;
			}
			//copy test into danger
			for (int i = 0; i < danger.length; i++) {
				danger[i] = test[i];
			}
		}
		return danger;
	}
	
	private static int countHits(int gf,int consecutives){
		int c=0;
		double dist = navigator.wave.getCenter().distance(navigator.me.pos());
		BitRater rater[] = navigator.gfHolder.getBitRater(dist);
		for (int j = gf-consecutives ; j <= gf+consecutives; j++) {
		  if(j>=0 && j<rater.length ){
		  	c+=rater[j].count(0, 65);
		  }
		}
		return c;
	}

	/**
	 * @param depth2
	 * @param dgrs
	 * @param lastGf2
	 * @param consecutives2
	 * @return
	 */
	private static boolean[] extractGF(boolean[] dgrs, int initGf, int gf,
			int consecutives) {
		int from = initGf;
		int to = initGf + dgrs.length - 1;
		boolean danger[] = new boolean[dgrs.length];
		//copy dgrs into danger
		for (int i = 0; i < danger.length; i++) {
			danger[i] = dgrs[i];
		}
		if ((gf >= from) && (gf <= to)) {
			danger[gf - from] = true;
		}
		for (int j = 0; j < consecutives; j++) {
			int pre = gf - (j + 1);
			int pos = gf + (j + 1);
			if ((pre >= from) && (pre <= to)) {
				danger[pre - from] = true;
			}
			if ((pos >= from) && (pos <= to)) {
				danger[pos - from] = true;
			}
		}
		return danger;
	}

	private static boolean[] setDangerPts(int depth, int consecutives) {
		return setDangerPts(depth, 0, SegmentedGFs.GF_QT - 1, consecutives);
	}

	private static int countDangerPts(int depth, int from, int to) {
		int tot = 0;
		double dist = navigator.wave.getCenter().distance(navigator.me.pos());
		BitRater rater[] = navigator.gfHolder.getBitRater(dist);
		for (int i = from; i < (to + 1); i++) {
			tot += (rater[i].isEmpty(depth)) ? 0 : 1;
		}
		return tot;
	}

	private static double getWorstGF() {
		double dist = navigator.wave.getCenter().distance(navigator.me.pos());
		BitRater rater[] = navigator.gfHolder.getBitRater(dist);
		int worstAmt = 0;
		double worstGF = Double.NaN;
		for (int i = SegmentedGFs.GF_QT - 1; i >= 0; i--) {
			int tot = rater[i].count(0, 64);
			if (tot > worstAmt) {
				worstAmt = tot;
				worstGF = i;
			}
		}
		return worstGF;
	}

	//deslocamento
	private static int getMaxDesloc(int ticks, boolean re) {
		//se re, dir =-1
		int dir = (re) ? -1 : 1;
		int step = 0;
		int tot = 0;
		//se re vel deve ser negativa
		int vel = (int) navigator.me.getVelocity();
		for (int i = 0; i < ticks; i++) {
			//desacelerando
			if ((dir * vel) < 0) {
				if (vel < 0) {
					vel += 2;
					vel = (vel > 0) ? 0 : vel;
				} else {
					vel -= 2;
					vel = (vel < 0) ? 0 : vel;
				}
			} else if (Math.abs(vel) < 8) {
				if (dir < 0) {
					vel -= 1;
					vel = (vel < -8) ? -8 : vel;
				} else {
					vel += 1;
					vel = (vel > 8) ? 8 : vel;
				}
			}
			tot += vel;
		}
		return tot;
	}

	private static int surfToWall(boolean re) {
		int ret = 0;
		int dir = (re) ? -1 : 1;
		//getMe().getWallAlert();
		double d = (35.0 / 2.0);
		double h = navigator.me.getBattleFieldHeight() - (2 * d);
		double w = navigator.me.getBattleFieldWidth() - (2 * d);
		Rectangle2D.Double r = new Rectangle2D.Double(d, d, w, h);
		AxeVector vec = new AxeVector(navigator.wave.getCenter(), navigator.me
				.pos());
		double ray = vec.getModule();
		double cc = ray * 2 * Math.PI;
		double step = 2 * Math.PI * (1.0 / cc);
		double acc = 0;
		//        step *= re ? 1 : -1;
		int vel = (int) navigator.me.getVelocity();
		//        System.out.println(
		//            "muro:" + vec.getEndPoint() + " re:" + re + " step:" + step);
		boolean test = true;
		while (!test || (r.contains(vec.getEndPoint()) && (acc < cc))) {
			ret++;
			//			desacelerando
			if ((dir * vel) < 0) {
				if (vel < 0) {
					vel += (vel < 0) ? +2 : -2;
					vel = (vel > 0) ? 0 : vel;
				} else {
					vel += (vel < 0) ? +2 : -2;
					vel = (vel < 0) ? 0 : vel;
				}
				acc -= Math.abs(vel);
			} else {
				if (Math.abs(vel) < 8) {
					vel += (dir < 0) ? -1 : 1;
				}
				acc += Math.abs(vel);
			}
			test = acc >= 0;
			//invertido, pois se vel negativa, sentido horario
			vec.addTheta(Math.toDegrees(-1 * step * vel));
			//            System.out.println("muro: vel:"+vel+" ang:"+vec.getTheta() +"
			// pt:" + vec.getEndPoint() );
		}
		ret -= (ret > 0) ? 1 : 0;
		vel = (int) navigator.me.getVelocity();
		if (Math.ceil(navigator.me.getVelocity() / 2D) > ret) {
			ret = 0;
		}
		return ret;
	}

	/**
	 * @return Returns the dangerPts.
	 */
	public static Boolean[] getDangerPts() {
		return dangerPts;
	}

	/**
	 * @return Returns the course.
	 */
	public static Course getCourse() {
		return course;
	}

	/**
	 *  
	 */
	public static void hitByBullet() {
		lastChangeTime = 0;
	}

	/**
	 * @return Returns the lastChangeTime.
	 */
	public static long getLastChangeTime() {
		return lastChangeTime;
	}

	/**
	 * @param lastChangeTime
	 *            The lastChangeTime to set.
	 */
	public static void setLastChangeTime(long lastChangeTime) {
		Course.lastChangeTime = lastChangeTime;
	}
}