package sul;
import robocode.*;
import robocode.util.*;

// Lunar 1.1 - a robot by Sulibilune.
//This is my first anti-gravity nanoBot.
// Credit to DustBunny for his movement.
// v1.1 a few changes, seems to work better.

public class Lunar extends AdvancedRobot {
	
	static double	trackingTargetDistance;	//distance to target we are tracking(distance to closest target)
	static double	forceX;					//x force made by enemy robots
	static double	forceY;					//y force made by enemy robots
	
	public void run() {
		
		//Good for better aiming.
		setAdjustGunForRobotTurn( true );
		// Radar spin.
		setTurnRadarRightRadians( trackingTargetDistance = Double.POSITIVE_INFINITY );
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double targetBearing;
		double distance = e.getDistance();
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		
		//calculate force from robots
		forceX = forceX * 0.865 - Math.sin(absoluteBearing) / distance;
		forceY = forceY * 0.865 - Math.cos(absoluteBearing) / distance;

		if ( distance < trackingTargetDistance + 160 ) {
			trackingTargetDistance = distance;
			//setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + ((e.getVelocity() * Math.sin(e.getHeadingRadians() -  absoluteBearing) / 13.0))) * Math.min(1,distance/500));
			//setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + ((e.getVelocity() * Math.sin(e.getHeadingRadians() -  absoluteBearing) / 13.0))));
			setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
		}
	
		//turn Lunar away from the anit gravity force. wall anti-gravity implemented
		setTurnRightRadians(Utils.normalRelativeAngle(Math.atan2(forceX + 1/getX() - 1/(getBattleFieldWidth() - getX()), forceY + 1/getY() - 1/(getBattleFieldHeight() - getY()))- getHeadingRadians()));
		setAhead(Double.POSITIVE_INFINITY);
		
		//slow down if turning.
		setMaxVelocity(500 / getTurnRemaining());
		
		//fireBullet(3);
		fireBullet(getOthers()/3);
	}
	
	//free the target we are tracking if a robot dies
	public void onRobotDeath( RobotDeathEvent e ) {
		trackingTargetDistance = Double.POSITIVE_INFINITY;
	}
}
