package maribo;

import java.awt.Color;
import java.awt.geom.Point2D;

import robocode.Rules;

abstract class Gun {
	public long[][] hits = new long[(Quester.numEn/3)+1][Quester.distSeg];
	public abstract String getName();
	public abstract Color getColor();
	public abstract double getFiringAngle(Enemy me, Enemy en, double bulletPower);
}

class CircularGun extends Gun {
	public String getName() { return "Circular Gun"; }
	public Color getColor() { return Color.GREEN; }
	public double getFiringAngle(Enemy me, Enemy en, double bulletPower) {
		double heading = en.heading;
		double deltaHeading = en.deltaHeading;
		double deltaTime = 1;
		Point2D.Double predicted = new Point2D.Double(en.x, en.y);
		while((++deltaTime) * Rules.getBulletSpeed(bulletPower) < me.distance(predicted)){		
			predicted = Quester.calcPos(predicted, en.velocity, heading);
			heading += deltaHeading;
			if(!Quester.board.contains(predicted)){ break; }
		}
		return Quester.calcAngle(predicted, me);
	}
}

class HeadOnGun extends Gun {
	public String getName() { return "Head-on Gun"; }
	public Color getColor() { return Color.ORANGE; }
	public double getFiringAngle(Enemy me, Enemy en, double bulletPower) {
		return Quester.calcAngle(en, me);
	}
}

class Linear50Gun extends Gun {
	public String getName() { return "50% Linear Gun"; }
	public Color getColor() { return Color.YELLOW; }
	public double getFiringAngle(Enemy me, Enemy en, double bulletPower) {
		double directAngle;
		return (directAngle  = Quester.calcAngle(en, me)) - 0.5 * en.velocity * Math.sin(directAngle - en.heading) / (20.0 - 3.0 * bulletPower);
	}
}

class LinearGun extends Gun {
	public String getName() { return "BotB Linear Gun"; }
	public Color getColor() { return Color.BLUE.darker(); }
	
	public double getFiringAngle(Enemy me, Enemy en, double bulletPower) {
		double deltaTime = 1;
		Point2D.Double predicted = new Point2D.Double(en.x, en.y);
		while ((++deltaTime) * Rules.getBulletSpeed(bulletPower) < me.distance(predicted)){		
			predicted = Quester.calcPos(predicted, en.velocity, en.heading);
			if (!Quester.board.contains(predicted)) { break; }
		}
		return Quester.calcAngle(predicted, me);
	}
}