package amk.superstrike;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.*;

/* This is the very first from-scratch robot by Aaron Krill */

public class SuperStrike extends TeamRobot
{
	FieldUnit target = null;
	int direction = 1;
	double firePower = 3;
	Random rand = new Random();
	Battlefield battlefield = new Battlefield();
	double oldEnergy = 0;
    double newEnergy = 0;
	boolean playing = true;
	double wallturn = 125;
	
	public void run() {
		setColors(new Color(0,50,100),new Color(0,50,100),new Color(0,50,100));
		
		addCustomEvent(new Condition("NearWall") {
				public boolean test() {
					double width = getBattleFieldWidth();
					double height = getBattleFieldWidth();
					double margin = 50;
					double curX = getX();
					double curY = getY();
					if(curX <= margin) {
						return true;
					}
					if(curY <= margin) {
						return true;
					}
					if(curX >= width-margin) {
						return true;
					}
					if(curY >= height-margin) {
						return true;
					}
					return false;
				};
		}); 
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		while(playing) {
			doMove();
			doSpeed();
			doScan();
			doChooseTarget();
			doGun();
			doSearchAndDestroy();
			doCheckForBullets();
			execute();
			
		}
	}
	
	public void doMove() {
		int moveType = rand.nextInt(12);
		int direction = rand.nextInt(8);
		if(direction == 1) {
			setAhead(40000);
		} else if(direction == 0) {
			setBack(40000);
		}
		switch(moveType) {
			case 0: setTurnRight(45); break;
			case 1: setTurnRight(90); break;
			case 2: setTurnLeft(45); break;
			case 3: setTurnLeft(90); break;
			case 4: setTurnRight(180); break;
			default: break;
		}
	}
	
	public void doSpeed() {
		int changeSpeed = rand.nextInt(4);
		int newSpeed = rand.nextInt(4)+4;
		if(changeSpeed != 0) { return; }
		setMaxVelocity(newSpeed);
	}
	
	public void doScan() {
		if(target == null) {
			setTurnRadarLeftRadians(2*Math.PI);
		}
	};
	
	void doGun() {
		if(target != null) {
			long time = getTime() + (int)(target.getDistance()/(20-(3*firePower)));
			double gunOffset = getGunHeadingRadians() - absoluteBearing(getX(),getY(),target.guessX(time),target.guessY(time));
			setTurnGunLeftRadians(NormalizeBearing(gunOffset));
		}
	}
	
	public void doSearchAndDestroy() {
		if(target != null) {
			double bulletPower = Math.min(2.0,getEnergy());
			double myX = getX();
			double myY = getY();
			double absoluteBearing = getHeadingRadians() + target.getBearingRadians();
			double enemyX = getX() + target.getDistance() * Math.sin(absoluteBearing);
			double enemyY = getY() + target.getDistance() * Math.cos(absoluteBearing);
			double enemyHeading = target.getHeadingRadians();
			double enemyVelocity = target.getSpeed();
			
			
			double deltaTime = 0;
			double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
			double predictedX = enemyX, predictedY = enemyY;
			while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
				predictedX += Math.sin(enemyHeading) * enemyVelocity;	
				predictedY += Math.cos(enemyHeading) * enemyVelocity;
				if(	predictedX < 18.0 
					|| predictedY < 18.0
					|| predictedX > battleFieldWidth - 18.0
					|| predictedY > battleFieldHeight - 18.0){
					predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
					predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
					break;
				}
			}
			double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
			
			setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
			setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
			setFire(bulletPower);
		}
	};
	
	public void doChooseTarget() {
		if(target != null) { return; }
		FieldUnit weakest = battlefield.getWeakestEnemy();
		FieldUnit closest = battlefield.getClosestEnemy();
		if(closest != null) {
			target = closest;
		} else if(weakest != null) {
			target = weakest;
		}
		
	}
	
    double NormalizeBearing(double ang) {
		if (ang > Math.PI)
			ang -= 2*Math.PI;
			if (ang < -Math.PI)
				ang += 2*Math.PI;
			return ang;
	}
	
	public double getrange( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = Math.sqrt( xo*xo + yo*yo );
		return h;
	}
	
	public double absoluteBearing( double x1,double y1, double x2,double y2 )
    {
		double xo = x2-x1;
		double yo = y2-y1;
		double h = getrange( x1,y1, x2,y2 );
		if( xo > 0 && yo > 0 )
		{
				return Math.asin( xo / h );
		}
		if( xo > 0 && yo < 0 )
		{
				return Math.PI - Math.asin( xo / h );
		}
		if( xo < 0 && yo < 0 )
		{
				return Math.PI + Math.asin( -xo / h );
		}
		if( xo < 0 && yo > 0 )
		{
				return 2.0*Math.PI - Math.asin( -xo / h );
		}
		return 0;
	}
	
	public double smallestToParallel(double angle) {
        if (angle > -90 && angle <= 90)
            return angle;
        double fixedAngle = angle;
        while (fixedAngle <= -90)
            fixedAngle += 180;
        while (fixedAngle > 90)
            fixedAngle -= 180;
        return fixedAngle;
    }
		
	public void onHitWall(HitWallEvent e) {
		setBack(-400);
		setTurnLeft(115);
		execute();
	}
	
	public void onHitByBullet(HitWallEvent e) {
		setBack(-1*(rand.nextInt(400)+50));
		setTurnLeft(rand.nextInt(160)+20);
		execute();
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double bulletPower = Math.min(2.5,getEnergy());
		
		FieldUnit thisUnit = new FieldUnit();
		thisUnit.setCreationTime(getTime());
		
		double myX = getX();
		double myY = getY();
		
		thisUnit.setName(e.getName());
		thisUnit.setAbsoluteBearing(e.getHeadingRadians() + e.getBearingRadians());
		thisUnit.setBearing(e.getBearing());
		thisUnit.setBearingRadians(e.getBearingRadians());
		thisUnit.setHeadingRadians(e.getHeadingRadians());
		thisUnit.setHeading(e.getHeading());
		thisUnit.setSpeed(e.getVelocity());
		thisUnit.setDistance(e.getDistance());
		thisUnit.setEnergy(e.getEnergy());
		thisUnit.setX(myX + thisUnit.getDistance() * Math.sin(thisUnit.getBearing()));
		thisUnit.setY(myY + thisUnit.getDistance() * Math.cos(thisUnit.getBearing()));
		
		if(isTeammate(e.getName())) { battlefield.addTeammate(thisUnit); }
		else { battlefield.addEnemy(thisUnit); }
		
		if(thisUnit.getDistance() <=49) {
			setMaxVelocity(8);
			turnLeft(smallestToParallel(90 - thisUnit.getBearing()));
			setAhead(50);
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		String name = e.getName();
		if(isTeammate(name)) {
			battlefield.deleteTeammate(name);
		} else {
			battlefield.deleteEnemy(name);
		}
		target = null;
	}
	
	public void onWin(WinEvent e) {
		playing = false;
		stop();
		setTurnLeft(3600);
		setTurnGunRight(3600);
		setTurnGunLeft(3600);
		execute();
	}
	
	public void doCheckForBullets() {
		Iterator it = battlefield.enemies.iterator();
		while(it.hasNext()) {
			FieldUnit unit = (FieldUnit)it.next();
			if(unit.hasFired()) {
				setMaxVelocity(8);
				turnLeft(smallestToParallel(90 - unit.getBearing()));
				setAhead(50);
				execute();
			}
		}
	}
	
	public void onCustomEvent(CustomEvent e)
    {
        if (e.getCondition().getName() == "NearWall") {
            setTurnLeft(wallturn);
			setAhead(50);
			execute();
        }
    }
}
