package SHAM;

import robocode.*;

import java.awt.*;
import java.awt.geom.*;
import java.*;


/**
 * 
 * SHAM.WOW created by Steven Hatton and Aditya Majumdar Period 3, JAVA
 * Programming Due: 06/05/09 Robocode, JAVA, Second Semester Final Project
 * 
 * Implements spinbot capabilities.
 * Will normally run in a circling movement. 
 * 
 */
public class SM
{
    private AdvancedRobot _robot;


    public SM( AdvancedRobot robot )
    {
        _robot = robot;
    }

    private AdvancedEnemyBot enemy = new AdvancedEnemyBot();


    /**
     * SpinBot's run method - Circle
     */
    public void run()
    {
        while ( true )
        {
            // Tell the game that when we take move,
            // we'll also want to turn right... a lot.
            _robot.setTurnRight( 10000 );
            // Limit our speed to 5
            _robot.setMaxVelocity( 5 );
            // Start moving (and turning)
            _robot.ahead( 10000 );
            // Repeat.
        }
    }


    /**
     * onScannedRobot: Fire hard!
     */
    public void onScannedRobot( ScannedRobotEvent e )
    {
        _robot.fire( 3 );
    }


    /**
     * onHitRobot: If it's our fault, we'll stop turning and moving, so we need
     * to turn again to keep spinning.
     */
    public void onHitRobot( HitRobotEvent e )
    {
        if ( e.getBearing() > -10 && e.getBearing() < 10 )
            _robot.fire( 3 );
        if ( e.isMyFault() )
            _robot.turnRight( 10 );
    }
}
