package tjk.universe;

/**
 * GFBracket - a class by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 * 
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */
public class GFBracket
{
	public double[] b;
	
	// displacement vector.
	public double[] vector;
	
	public boolean real;
	
	public double[] gunHits;
	
	public static final double[] EMPTY_GH = {0.0,0.0,0.0,0.0,0.0,0.0,0.0};
	
	public int round = 0;
	
	public GFBracket(Wave w)
	{
		
		real = w.real;
		
		this.b = w.getHitBracket();
		if ( b[0] > b[1] )
		{
			double temp = b[0];
			b[0] = b[1];
			b[1] = temp;
		}
	
		gunHits = w.gunHits();
		vector = w.displacementVector;
		round = Universe.getRoundNum();
	}
	
	public GFBracket(boolean rl, double[] bracket, double[] vec)
	{
		this.real = rl;
		this.b = bracket;
		if ( this.b[0] > this.b[1] )
		{
			double temp = this.b[0];
			this.b[0] = this.b[1];
			this.b[1] = temp;
		}
		this.vector = vec;
		this.gunHits = EMPTY_GH;
	}

}
