package kawigi.nano;
import robocode.*;
import java.awt.geom.*;
import java.text.*;
/*
 * Lib - nano melee bot - brother of Shiz who was killed by Coriantumr
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 *	The inspiration for this bot was a discussion with David Alves about how
 *	Big and inefficient SandboxLump's corner movement is (relating to the fact
 *	that we don't ever expect Paul Evans to make a nano).  I decided to show
 *	that more complicated corner movement can fit into a nano, with a little
 *	creativity (and probably a few assumptions).
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 *	Version 1.0 - 246 bytes.  Shoots head on, some nano-melee-ish energy
 *			management and the following corner movement:
 *			2
 *			4     5
 *			7
 *			1  3  6  8
 */
public class Lib extends AdvancedRobot
{
	static final int PATTERN_LENGTH = 8;
	//These are the coordinates of our corner movement (if it was in the lower-left corner).
	//The length of these strings should be PATTERN_LENGTH and Lib should have to change
	//directions (as in forward or reverse) for each point.
	static final String xcoords = ("" + (char)30 + (char)30 + (char)90 + (char)30 + (char)150 + (char)150 + (char)30 + (char)210);
	static final String ycoords = ("" + (char)30 + (char)210 + (char)30 + (char)150 + (char)150 + (char)30 + (char)90 + (char)30);
	
	//this will normalize to PI/2, but it is big enough that I can use it for setAhead, too.
	static double direction = 41*Math.PI/2;
	
	//this variation is based loosely off of SandboxMiniMelee:
	//static final int PATTERN_LENGTH = 10;
	//static final String xcoords = ("" + (char)50 + (char)150 + (char)50 + (char)150 + (char)50 + (char)150 + (char)200 + (char)250 + (char)200 + (char)150);
	//static final String ycoords = ("" + (char)150 + (char)200 + (char)250 + (char)200 + (char)150 + (char)50 + (char)150 + (char)50 + (char)150 + (char)50);
	
	public void run()
	{
		setAdjustGunForRobotTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		int index=0;
		do
		{
			double goaly = ycoords.charAt(index);
			double myy;
			if ((myy = getY()) > 500)
				goaly = getBattleFieldHeight()-goaly;
			double goalx = xcoords.charAt(index);
			double myx;
			if ((myx = getX()) > 500)
				goalx = getBattleFieldWidth()-goalx;
			if (Point2D.distance(goalx, goaly, myx, myy) < 10)
			{
				direction = -direction;
				index = (index+1)%PATTERN_LENGTH;
			}
			setAhead(direction);
			//the SandboxMiniMelee version of the movement is buggy without this in there, the default movement is fine without it:
 			//setAhead(getTurnRemainingRadians()==0 ? direction : 0);
			setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(Math.atan2(goalx-myx, goaly-myy) + Math.PI/2-direction - getHeadingRadians()));
			execute();
		}
		while (true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		double energy;
		if ((energy = getEnergy()) > 1 && setFireBullet(20*getOthers()*energy/e.getDistance()) == null)
			//this lets my radar slip when I fire so that people can't sneak up on me for locking my radar.
			setTurnRadarLeft(getRadarTurnRemaining());
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(e.getBearingRadians()+getHeadingRadians()-getGunHeadingRadians()));
		clearAllEvents();
	}
	
	public void onHitRobot(HitRobotEvent e)
	{
		if (e.isMyFault())
			direction = -direction;
	}
}