package dam.movement;

import dam.Target;


public class JiggleMove extends MovementStrategy
{
	protected int attackMode = 1;

	public void doMove()
	{
		if(attackMode == 1) doWing();
		else doCut();
	}
	
	public void onNearWall()
	{
		doAvoid();
	}
	
	public void doCut()
	{
		direction *= -1;
		Target target = bot.getTarget();
		double bearing = bot.normaliseBearing(target.getBearing() - PI/2);
		setAhead(300 * direction);
		setTurnRightRadians(bearing);
		setMoveCount(rand.nextInt(15) + 5 + bot.getTime());
		attackMode = 1;
	}
	
	public void doWing()
	{
		direction *= -1;
		double bearing = bot.normaliseBearing(bot.getTarget().getBearing() - PI/2);
		setAhead(300 * direction);
		setTurnRightRadians(bearing);
		setMoveCount(rand.nextInt(15) + 5 + bot.getTime());
		attackMode = 2;
	}
	
	public void doAvoid()
	{
		AntiGravity g = new AntiGravity(getBattleFieldWidth(), getBattleFieldHeight());
		g.calculate(getX(), getY(), bot.getHeadingRadians());
		direction = g.getDirection();
		double angle = g.getAngle();		
		setTurnRightRadians(angle);
		setAhead(direction * 200);
		setMoveCount(getTime() + 20);
	}
	

}