package dam.movement;

import java.util.*;

import dam.EnemyBullet;
import dam.Target;
import dam.TargetList;
import dam.util.*;

public class MoggyMovement extends MovementStrategy
{

	/**
	* Melee movement
	*/
	public void doMove()
	{
		// put a mountain in the middle of the field, because it's a dumb place to stand
		double fwidth = bot.getBattleFieldWidth();
		double fheight = bot.getBattleFieldHeight();
		double gravWeight = 3 * Math.max(fwidth, fheight) * -1;
		GridPoint middle = new GridPoint(fwidth/2, fheight/2, gravWeight);
		double px = 25 + (((int)(Math.random() * 5)) * 20);
		double py = 25 + (((int)(Math.random() * 5)) * 20);
				
		TargetList targets = bot.getTargetList();
		AntiGravity g = new AntiGravity(fwidth, fheight);
		for(int i = 0; i < targets.size(); i++)
		{
			g.add(targets.get(i).getGridPoint());
		}
		Target target = bot.getTarget();
		Vector v = target.getBullets();
		long ctime = bot.getTime();
		long ntime = ctime + 1;
		for(int i = 0; i < v.size(); i++)
		{
			EnemyBullet b = (EnemyBullet)v.elementAt(i);
			g.add(b.getPosition(ctime));
			g.add(b.getPosition(ntime));
		}
		int others = bot.getOthers();
		if(others > 1){
			g.add(middle);
		}
		g.add(bot.getHitPoint());
		g.calculate(getX(), getY(), bot.getHeadingRadians());
		direction = g.getDirection();

		double angle = constrainTurn(g.getAngle(), 30);		

		bot.setTurnRightRadians(angle);
		bot.setAhead(direction * 200);
		setMoveCount(bot.getTime() + rand.nextInt(10) + 2);
	}
	
	// constrain the turn to be one of the cardinal directions, and at least 22 degs
	private double constrainTurn(double angle, double degrees)
	{
		double cusp = Math.toRadians(degrees);
		double base = angle % cusp;
		angle = angle - base;
		if((angle >= 0) && (angle < cusp)) angle = cusp;
		else if((angle < 0) && (angle > -(cusp))) angle = -(cusp);
		return angle;
	}




}