package cs.s2.misc;

import java.awt.geom.Point2D;

public final class Tools {
	public static final int signum(double d) {
		if(d == 0) return 0;
		if(d > 0) return 1;
		return -1;
	}

	public static final int sign(double d) {
		if(d < 0) return -1;
		return 1;
	}
	
	public static final double limit(double min, double value, double max) {
		if (value > max) return max;
		if (value < min) return min;
		return value;
	}
	
	public static final double bulletSpeedToPower(double speed) {
		return (speed - 20)/(-3);
	}

	public final static Point2D.Double project(Point2D p, double ang, double dist) {
		return new Point2D.Double(p.getX() + dist*Math.sin(ang), p.getY() + dist*Math.cos(ang));
	}
	
	public static final double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
}
