package cs.s2.misc;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import cs.s2.stat.StatBufferSet;
import cs.s2.stat.StatData;

import robocode.util.Utils;

@SuppressWarnings("serial")
public final class Wave extends Point2D.Double {
	public boolean realWave = false;
	public double bulletSpeed;
	public double baseAngle;
	public double linearGF = 0;
	public double circularGF = 0;
	public double escapeAngle;
	public double[] data; //, bins;
	public double min = java.lang.Double.POSITIVE_INFINITY;
	public double max = java.lang.Double.NEGATIVE_INFINITY;
	public long fireTime;
	private boolean checked = false;
	public double realWeight = 5.0;
	public double fakeWeight = 1.0;
	
	public boolean moveWave = false;
	
	private Wave() {}
	
	public void resetMinMax() {
		min = java.lang.Double.POSITIVE_INFINITY;
		max = java.lang.Double.NEGATIVE_INFINITY;
		checked = false;
	}
	
	public Wave(Point2D p, double angle, double speed, int direction, long time) {
		setLocation(p);
		bulletSpeed = speed;
		baseAngle = angle;
		escapeAngle = Math.asin(8 / speed) * direction * 1.05;
		fireTime = time;
	}
	
	public final boolean check(Point2D enemy, long time, StatBufferSet sbs, boolean shouldUpdate) {
		Rectangle2D.Double hitBox = new Rectangle2D.Double(
				enemy.getX()-18,enemy.getY()-18, 36, 36);
		
		//Less grazing please!
		if(moveWave) {
			hitBox = new Rectangle2D.Double(enemy.getX()-20,enemy.getY()-20, 40, 40);
		}
		
		Point2D[] pts = GeomTools.intersectRectCircle(hitBox, this, distance(time));
		Point2D[] pts2 = GeomTools.intersectRectCircle(hitBox, this, distance(time-1));
		if(pts.length > 0 || pts2.length > 0) {
			//Check intersection
			Point2D[] corner = GeomTools.getCorners(hitBox);
			for(Point2D p : pts) {
				double angle = Utils.normalRelativeAngle(Tools.absoluteBearing(this, p) - baseAngle);
				if(angle < min) min = angle;
				if(angle > max) max = angle;
			}
			for(Point2D p : pts2) {
				double angle = Utils.normalRelativeAngle(Tools.absoluteBearing(this, p) - baseAngle);
				if(angle < min) min = angle;
				if(angle > max) max = angle;
			}
			for(Point2D p : corner) {
				if(distance(p) > distance(time-1) && distance(p) < distance(time)) {
					double angle = Utils.normalRelativeAngle(Tools.absoluteBearing(this, p) - baseAngle);
					if(angle < min) min = angle;
					if(angle > max) max = angle;
				}
			}
			checked = true;
		} else if(checked) {
			if(shouldUpdate) {
				//Use the calculated data to determine the best GF to use to update this
				double offset = Utils.normalRelativeAngle(min + max) / 2.0;
				double gf = offset / escapeAngle;
				
				if(realWave) {
					sbs.update(new StatData(data,gf), realWeight);
				} else {
					sbs.update(new StatData(data,gf), fakeWeight);
				}
			}
			
			return true;
		}
		
		return false;
	}
	
	public Wave clone() {
		Wave w = new Wave();
		w.setLocation(this);
		w.baseAngle = this.baseAngle;
		w.bulletSpeed = this.bulletSpeed;
		w.linearGF = this.linearGF;
		w.circularGF = this.circularGF;
		w.escapeAngle = this.escapeAngle;
		w.fireTime = this.fireTime;
		w.realWave = this.realWave;
		w.realWeight = this.realWeight;
		w.fakeWeight = this.fakeWeight;
		w.data = this.data;
		w.moveWave = true;
		
		return w;
	}
	
	public final double distance(long time) {
		return (time-fireTime) * bulletSpeed;
	}
}