package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
import java.awt.geom.*;

public class BulletDodgerMovement extends MovementStrategy implements java.io.Serializable
{
	private transient GravityManager bulletcontainer;
	private transient double targetx, targety;
	public BulletDodgerMovement(AdvancedRobot robot, TargetSelector targetter, GravityManager mgr)
	{
		super(robot, targetter);
		bulletcontainer = mgr;
	}
	
	public void onEvent(Event e)
	{
	}
	
	public void setAction()
	{
		DefensiveVirtualBullet[] guessbullets = bulletcontainer.getActiveBullets(robot.getTime());
		findLocation(guessbullets);
		//go to targetx, targety
		double bearing = Math.atan2(targetx-robot.getX(), targety-robot.getY());
		if (turnTo(bearing))
			robot.setBack(distance(targetx-robot.getX(), targety-robot.getY()));
		else
			robot.setAhead(distance(targetx-robot.getX(), targety-robot.getY()));
	}
	
	private double distance(double dx, double dy)
	{
		return Math.sqrt(dx*dx+dy*dy);
	}
	
	private boolean turnTo(double absbearing)
	{
		double theta = absbearing-robot.getHeadingRadians();
		theta = ((theta + Math.PI)%(Math.PI*2)-Math.PI*2)%(Math.PI*2)+Math.PI;
		boolean back = false;
		if (theta > Math.PI/2)
		{
			back = true;
			theta -= Math.PI;
		}
		else if (theta < -Math.PI/2)
		{
			back = true;
			theta += Math.PI;
		}
		if (theta > 0)
			robot.setTurnRightRadians(theta);
		else
			robot.setTurnLeftRadians(-theta);
		return back;
	}
	
	private void findLocation(DefensiveVirtualBullet[] guessbullets)
	{
		double myx = robot.getX(), myy = robot.getY();
		double x = myx, y = myy;
		long time = robot.getTime();
		Line2D[] lasers = new Line2D[guessbullets.length];
		for (int i=0; i<lasers.length; i++)
			lasers[i] = guessbullets[i].getVirtualLaser(time);
		if (hit(lasers, targetx, targety) == 0 && distance(targetx-myx, targety-myy) < 200)
			return;
		double bestx = x, besty=y;
		int fewesthits = hit(lasers, x, y);
		if (fewesthits == 0)
		{
			targetx = bestx;
			targety = besty;
			return;
		}
		for (int dist = 15; dist < 150; dist+=15)
		{
			double anglestart = Math.random()*Math.PI*2;
			for (double angle = anglestart; angle < Math.PI*2+anglestart; angle +=Math.PI/12)
			{
				x = myx + dist*Math.sin(angle);
				y = myy + dist*Math.cos(angle);
				if (offTheBoard(x, y))
					continue;
				int hits = hit(lasers, x, y);
				if (hits < fewesthits)
				{
					fewesthits = hits;
					bestx = x;
					besty = y;
				}
				if (fewesthits == 0)
				{
					targetx = bestx;
					targety = besty;
					return;
				}
			}
		}
	}
	
	private boolean offTheBoard(double x, double y)
	{
		return x < 30 || y < 30 || x > robot.getBattleFieldWidth()-30 || y > robot.getBattleFieldHeight()-30;
	}
	
	private int hit(Line2D[] lasers, double x, double y)
	{
		Rectangle2D.Float boundingBox = new Rectangle2D.Float();
		boundingBox.setRect(x - 22, y - 22, 44, 44);		//make a virtual robot bigger than myself
		int hits = 0;
		for (int i=0; i<lasers.length; i++)
			if (boundingBox.intersectsLine(lasers[i]))
				hits++;
		return hits;
	}
}
