package sgp;
import robocode.*;
import java.util.*;

/**
 * LinearIntercept - a class by (your name here)
 */
public class LinearIntercept extends Intercept
{
	protected double angularVelocity_rad_per_sec;

	public void calculate
		(
			double xb,
			double yb,
			double xt,
			double yt,
			double tHeading,
			double vt,
			double bPower,
			double angularVelocity_deg_per_sec
		)
	{
		angularVelocity_rad_per_sec = Math.toRadians(angularVelocity_deg_per_sec);

		bulletStartingPoint.set(xb, yb);
		targetStartingPoint.set(xt, yt);

		targetHeading = tHeading;
		targetVelocity = vt;
		bulletPower = bPower;
		double vb = 20-3*bulletPower;

		impactTime = 0;
		double dX,dY;
		double radialError = 1000.0;

		impactTime = getImpactTime(10, 20, 0.01);
		impactPoint = getEstimatedPosition(impactTime);
		//out.println("x " + impactPoint.x + ", y " + impactPoint.y);
		dX = (impactPoint.x - bulletStartingPoint.x);
		dY = (impactPoint.y - bulletStartingPoint.y);

		distance = Math.sqrt(dX*dX+dY*dY);

		bulletHeading_deg = Math.toDegrees(Math.atan2(dX,dY));
		angleThreshold = Math.toDegrees(Math.atan(MadHatter.ROBOT_RADIUS/distance));
	}

	protected Coordinate getEstimatedPosition(double time)
	{
		double x = targetStartingPoint.x + targetVelocity * time * Math.sin(Math.toRadians(targetHeading));
		double y = targetStartingPoint.y + targetVelocity * time * Math.cos(Math.toRadians(targetHeading));
		return new Coordinate(x,y);
	}

	private double f(double time)
	{
		double vb = 20-3*bulletPower;

		Coordinate targetPosition = getEstimatedPosition(time);
		double dX = (targetPosition.x - bulletStartingPoint.x);
		double dY = (targetPosition.y - bulletStartingPoint.y);

		return Math.sqrt(dX*dX + dY*dY) - vb * time;
	}

	private double getImpactTime(double t0, double t1, double accuracy)
	{
		double X = t1;
		double lastX = t0;
		int iterationCount = 0;
		double lastfX = f(lastX);

		while ((Math.abs(X - lastX) >= accuracy) && (iterationCount < 15))
		{
			iterationCount++;

			double fX = f(X);


			if ((fX-lastfX) == 0.0) break;

			double nextX = X - fX*(X-lastX)/(fX-lastfX);

			lastX = X;
			X = nextX;
			lastfX = fX;
		}

		//out.println("count " + iterationCount + ",X " + X + ",lX " + lastX);

		return X;
	}
}