package ph.musketeer;

import java.awt.geom.*;

public class util {
    
    public static double normalFirePower(double fp) {
        return Math.max(0.1,Math.min(3,fp));
    }
    
    public static double firePowerToKill(double energy) {
        double firePower = (energy + 2d) / 6d;
        if(firePower <= 1d) firePower = energy / 4d;
        return normalFirePower(firePower);
    }
    
    public static  double firePower(double myEnergy, double enemyEnergy, double enemyDistance) {
        return normalFirePower(Math.min(myEnergy / 5, Math.min(firePowerToKill(enemyEnergy), enemyDistance <= 150 ? 3 : 1.9)));
    }
    
    public static double getBulletSpeed(double power) {
        return 20-power*3;
    }
    
    public static double maxEscapeAngle(double power) {
        return Math.asin(8/getBulletSpeed(power));
    }
    
    public static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
        sourceLocation.getY() + Math.cos(angle) * length);
    }
    
    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
    public static RoundRectangle2D fieldRectangle(double width, double height, double margin) {
        return new RoundRectangle2D.Double(margin, margin,
        width - margin * 2, height - margin * 2, 75, 75);
    }
}
