package kawigi.mini;
import java.awt.geom.*;

/**
 * MeleeBullet - essentially the same as MiniBullet, but uses Points instead of more
 *		doubles.  Most important feature is probably missed scan interpolation.
 */
public class MeleeBullet
{
	Point2D startPoint, lastPoint;
	double startgunheading, direction, bulletspeed, bulletd;
	long lasttime;
	int[] segment;
	
	//returns true if this wave hit and should be removed
	public boolean updateEnemy(Point2D enemy, long time)
	{
		//I just linearly interpolate where they've been if I don't get an update each tick.  Should be a
		//reasonable interpolation, at least relative to firing angle, and I figure it's a must for melee:
		long dtime;
		double dx = (enemy.getX()-lastPoint.getX())/(dtime = time-lasttime);
		double dy = (enemy.getY()-lastPoint.getY())/dtime;
		while (lasttime < time)
		{
			if (startPoint.distance(lastPoint) <= bulletd)  	//could have hit now.
			{
				//increments the appropriate bucket
				segment[Math.min(30, Math.max(0, (int)Math.round((1+robocode.util.Utils.normalRelativeAngle(Coriantumr.angle(lastPoint, startPoint)-startgunheading)/direction)*15)))]++;
				return true;
			}
			lasttime++;
			//ha!  I don't need the bullet firing time!
			bulletd += bulletspeed;
			//this is actually reasonably small:
			lastPoint.setLocation(lastPoint.getX()+dx, lastPoint.getY()+dy);
		}
		return false;
	}
}
