package dl;
import robocode.*;
import robocode.util.*;
import java.awt.Color;
import java.awt.geom.*;


/**
 * Walls - a sample robot by Mathew Nelson, and maintained by Flemming N. Larsen
 * Updated by Daniel Lie to use linear targeting.
 * 
 * Moves around the outer edge with the gun facing in.
 */
public class BetterWalls extends AdvancedRobot {

	double moveAmount; // How much to move
	MoveCompleteCondition moveComplete = new MoveCompleteCondition(this);
	TurnCompleteCondition turnComplete = new TurnCompleteCondition(this);
	boolean turning = false;

	/**
	 * run: Move around the walls
	 */
	public void run() {
		// Set colors
		setBodyColor(Color.black);
		setGunColor(Color.black);
		setRadarColor(Color.red);
		setBulletColor(Color.red);
		setScanColor(Color.red);
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		// Initialize moveAmount to the maximum possible for this battlefield.
		moveAmount = Math.max(getBattleFieldWidth(), getBattleFieldHeight());
		
		// turnLeft to face a wall.
		// getHeading() % 90 means the remainder of 
		// getHeading() divided by 90.
		turnLeft(getHeading() % 90);
		setTurnRadarRight(360);
		ahead(moveAmount);
		// Turn the gun to turn right 90 degrees.
		setTurnGunRight(180);
		setTurnRight(90);
		
		while (true) {
			//if not moving and not turning, then turn.
			if(turning && moveComplete.test() && turnComplete.test()){
				setTurnGunRight(90);
				setTurnRight(90);
				turning = false;
			}
			//if not moving and not turning, then turn.
			if(!turning && moveComplete.test() && turnComplete.test()){
				ahead(moveAmount);
				turning = true;
			}
		setTurnRadarRight(360);
			execute();
		}
	}
	
	/**
	 * onHitRobot:  Move away a bit.
	 */	
	public void onHitRobot(HitRobotEvent e) {
		// If he's in front of us, set back up a bit.
		if (e.getBearing() > -90 && e.getBearing() < 90) {
			back(100);
		} // else he's in back of us, so set ahead a bit.
		else {
			ahead(100);
		}
	}

	/**
	 * onScannedRobot:  Fire!
	 */	
	public void onScannedRobot(ScannedRobotEvent e) {
		double bulletPower;// = Math.min(3.0,getEnergy());
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
		
		if(e.getDistance() < 300) bulletPower = Math.min(3.0,getEnergy());
		else bulletPower = Math.min(1.0,getEnergy());
		
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 17.0 
				|| predictedY < 17.0
				|| predictedX > battleFieldWidth - 17.0
				|| predictedY > battleFieldHeight - 17.0){
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));

		setFire(bulletPower);		
		// Note that scan is called automatically when the robot is moving.
		// By calling it manually here, we make sure we generate another scan event if there's a robot on the next 
		// wall, so that we do not start moving up it until it's gone.
	}
}
