package kvk.Utils;
import java.util.Arrays;
import kvk.ExtendedRobot;

/**
 *  Classe de stockage des vitesses et changements de direction
 *
 * @author     Ssin.le.Terrible
 * @created    9 fvrier 2004
 */
public class MoveList {
	private final static  int      DEFAULT_MAX_SIZE  = 100;                        //taille maxi par dfaut de la liste
	private               Point[]  moveList;                                       //liste
	private               int      next;                                           //position du prochain lment  ajouter
	private               int      maxSize;                                        //taille maxi de la liste
	private               int      size;                                           //nombre d'lments de la liste

	/**
	 *  Constructor pour l'objet MoveList
	 *
	 * @param  _maxSize  Description of the Parameter
	 */
	public MoveList(int _maxSize) {
		maxSize = _maxSize;
		size = 0;
		next = 0;
		moveList = new Point[maxSize + 2];
		Arrays.fill(moveList, null);
	}

	public MoveList() {
		this(DEFAULT_MAX_SIZE);
	}

	// ***************************** METHODES D'ACCES ***************************** //
	public int getMaxSize() {
		return maxSize;
	}

	public int getSize() {
		return size;
	}

	public Point get(int index) {
		if (index < 0 && index >= maxSize) {
			return null;
		}
		//Recherche du bon lment par rotation
		index += (index < next ? 0 : next);
		index -= (index < maxSize ? 0 : maxSize);
		return moveList[index];
	}
	// **************************************************************************** //
	/**
	 *  Ajoute un lment  la liste
	 *  La gestion de la taille de la liste se fait par rotation de l'index
	 *
	 * @param  element  Description of the Parameter
	 */
	public void add(Point element) {
		moveList[next++] = element;
		next -= (next < maxSize ? 0 : maxSize);
		size = (++size < maxSize ? size : maxSize);
	}
}

