package franzor.guns;

import robocode.*;
import franzor.*;
import java.awt.geom.Point2D;

/**
 * MyClass - a class by (your name here)
 */
public class DisplacementGun implements Gun {
	
	public DisplacementGun() { }
		
	public Point2D getGunTarget(Info info, StatPack stats, AdvancedRobot lizt, double vbullet) {
		if(info == null || stats == null) return null;
		
		//starts at 0, but should make educated guess in the future
		Point2D myLoc = new Point2D.Double(lizt.getX(), lizt.getY());
		return recursiveAim(0, info, stats, myLoc, vbullet);
	}
	
	private Point2D recursiveAim(long time, Info info, StatPack stats, Point2D myLoc, double vbullet) {
		if(time >= 99 || time < 0) return null;
			
		MathVector mv = stats.getAverageDisplacement(time, info.velocity().getMagnitude());
		if(mv == null) return recursiveAim(time + 1, info, stats, myLoc, vbullet);
			
		Point2D pos = locForDisplacement(info, mv);
		long realTime = (long)(myLoc.distance(pos)/vbullet);
		
		if(realTime < time) {
			return null;
		} else if(realTime == time) {
			return pos;
		} else {
			return recursiveAim(time + 1, info, stats, myLoc, vbullet);
		}
	}
	
	private Point2D locForDisplacement(Info info, MathVector displacement) {
		double mag = displacement.getMagnitude();
		double theta = robocode.util.Utils.normalAbsoluteAngle(info.velocity().getDirection()) +
					   robocode.util.Utils.normalAbsoluteAngle(displacement.getDirection());
		double x = info.location().getX() + mag*Math.sin(theta);
		double y = info.location().getY() + mag*Math.cos(theta);
		
		return new Point2D.Double(x, y);
	}
}
