package bvh.tyr;
import robocode.*;

public class RadarManager implements Constanten {
/**********************************************************************
*  RADAR-STURING
**********************************************************************/
   static  Doel    mijnDoel;
   static  Tyr     mijnBot;
           boolean doelGevonden = false;
           int     draairichting= 1;

   public RadarManager(Tyr bot, Doel doel) {
      mijnBot  = bot;
      mijnDoel = doel;
   }

/**
* stuurRadar: doel is om tegenstander eerst te vinden, dan te volgen:
*
*/
   public void stuurRadar() {
      if(doelGevonden && mijnBot.getOthers() < standaardAantalBots) {
         radar1Vs1();
      }
      else {
         radarMelee();
      }
   }

   public void radar1Vs1() {// draaicirkel verkleinen tot richting van doel + bewegings "onscherpte":
      // meteen hoek normaliseren omdat de hoek nog wel eens groter dan 360 graden wil zijn...
      double radarDraaicirkel = Utils.normaliseBearing( mijnDoel.richting - mijnBot.getRadarHeadingRadians() );

      if (radarDraaicirkel < 0) radarDraaicirkel -= correctieRadarDraaicirkel;
      else                      radarDraaicirkel += correctieRadarDraaicirkel;

      mijnBot.setTurnRadarRightRadians(radarDraaicirkel);
    }

   public void radar1Vs1(double hoekDoel) {// radar richting opgegeven hoek draaien
      double radarDraaicirkel = Utils.normaliseBearing( hoekDoel - mijnBot.getRadarHeadingRadians() );
      double extraDraai = 1;
      if (Math.abs(radarDraaicirkel) < 0.17) extraDraai = 2;

      if (radarDraaicirkel < 0) radarDraaicirkel -= (correctieRadarDraaicirkel * extraDraai);
      else                      radarDraaicirkel += (correctieRadarDraaicirkel * extraDraai);
      radarDraaicirkel = Utils.normaliseBearing( radarDraaicirkel ); // alleen bij korte sweep

      mijnBot.setTurnRadarRightRadians(radarDraaicirkel);
    }

   public void radarMelee() { // indien groepsgevecht, dan hele cirkel bestrijken:
      mijnBot.setTurnRadarRightRadians( draairichting * standaardDraaicirkel);
   }

   public void setRadarDraairichting(int in) {
      draairichting = in;
   }
   public void RadarDraairichtingOmkeren() {
      draairichting = -draairichting;
   }
   public void setDoelGevonden(boolean in) {
      doelGevonden = in;
   }
   public boolean getDoelGevonden() {
      return doelGevonden;
   }

} // EINDE RadarManager