package dft.bin;

import java.util.ArrayList;
import java.util.Enumeration;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BASIC {

	private static final int MIDDLE_FACTOR = 27;
	private static final int TOTAL_FACTORS = 55;
	
	private static Buffer stats = new Buffer(TOTAL_FACTORS);
	private static Buffer otherStats = new Buffer(TOTAL_FACTORS);
	private static Buffer raw = new Buffer(TOTAL_FACTORS);
		
	public void think(WaveManager waves, State s, Log log) {
		
		Rectangle2D battleField = new Rectangle2D.Double(18,18,s.getRobot().getBattleFieldWidth()-36,s.getRobot().getBattleFieldHeight()-36);		
		ReducedState p = log.get(-1);
		
		double bulletPower = 1.9;
		if (s.getRobot().getEnergy()<= 2.0) bulletPower = 0;
		if (s.getEnemyDistance() < 240) bulletPower = 3.0;
		//bulletPower = 3.0;
		
		double bulletSpeed = 20 - 3*bulletPower;
	
		int bestIndex = MIDDLE_FACTOR;
		
		GunWave w = new GunWave();
		w.targetLocation = Utils.project(s.getEnemyLocation(),0,0);
		w.waveOrigin = w.waveLocation = Utils.project(s.getRobotLocation(),0,0);
		w.angle = s.getAbsBearing();
		w.velocity = bulletSpeed;
		w.lastTime = s.getRobot().getTime();
		w.escapeEnvelope = Utils.escapeEnvelope(s.getEnemyDirection(),w.velocity);
		
		double wallDistance = 1.0;
		for (; wallDistance >= 0; wallDistance-=0.25) {
			if (battleField.contains(
					Utils.project(s.getRobotLocation(), 
							s.getAbsBearing() + wallDistance*w.escapeEnvelope, 
							s.getEnemyDistance())))
				break;
		}
		
		double reverseWallDistance = 1.0;
		for (; reverseWallDistance >= 0; reverseWallDistance-=0.5) {
			if (battleField.contains(
					Utils.project(s.getRobotLocation(), 
							s.getAbsBearing() - reverseWallDistance*w.escapeEnvelope, 
							s.getEnemyDistance())))
				break;
		}
		
		int distanceIndex = (int)(s.getEnemyDistance()/240.0);		
		int fastDistanceIndex = (int)(s.getEnemyDistance()/360.0);
		
		int wallIndex = (int)(wallDistance*4.0);
		int fastWallIndex = (int)(wallDistance*2.0);
		
		int reverseWallIndex = (int)((reverseWallDistance)*2.0);
		int fastReverseWallIndex = (int)((reverseWallDistance+0.5)*1.0);
		
		int velIndex = (int)Math.abs(s.getEnemyLateralVelocity()/2.00);		
		int fastVelIndex = (int)Math.abs(s.getEnemyLateralVelocity()/4.00);
				
		double moveTime = bulletSpeed*s.getEnemyTimeSinceVelocityChange()/s.getEnemyDistance();
		
		int timerIndex = moveTime < 0.2 ? 1 : moveTime < 0.4 ? 2 : moveTime < 1.2 ? 3 : 4;		
		int fastTimerIndex = moveTime < 0.8 ? 1 : 2;	
		
		int accelIndex = (int)Math.round(Math.abs(s.getEnemyVelocity()) - Math.abs(p.getEnemyVelocity()));
		
		if (accelIndex != 0) {
			accelIndex = accelIndex > 0 ? 2 : 1;
			timerIndex = fastTimerIndex = 0;
		}		
				
		double[] fastStats = stats.getCurrentBucket(new int[] {accelIndex,distanceIndex,wallIndex,reverseWallIndex,velIndex,timerIndex});
		double[] currentStats = otherStats.getCurrentBucket(new int[] {accelIndex,fastDistanceIndex,fastWallIndex,fastReverseWallIndex,fastVelIndex,fastTimerIndex});
		double[] rawStats = raw.getCurrentBucket(new int[] {});
				
		int factorsInRange = Utils.hittableFactors(s.getEnemyDistance(),TOTAL_FACTORS,bulletSpeed);
		
		bestIndex = 1;
		double bestValue = 0;
		for (int i=1; i<1+factorsInRange; i++) {
			bestValue += currentStats[i]+fastStats[i]+rawStats[i]*.02;	
		}
		double currentValue = bestValue;
		for (int i=bestIndex+1; i<TOTAL_FACTORS-factorsInRange; i++) {
			currentValue -= currentStats[i-1]+fastStats[i-1]+rawStats[i-1]*.02;
			currentValue += currentStats[i+factorsInRange-1]+fastStats[i+factorsInRange-1]+rawStats[i+factorsInRange-1]*.02;
			if (currentValue >= bestValue) {				
				bestValue = currentValue;
				bestIndex = i;
			}
		}
		
		bestIndex+=(factorsInRange-1)/2;
	
		if (s.getRobot().getGunHeat()>0) {		
			if (s.getRobot().getGunHeat() < s.getRobot().getGunCoolingRate()*2) {	
				double GF = (bestIndex-MIDDLE_FACTOR)/(double)MIDDLE_FACTOR;
				double angleOffset = w.escapeEnvelope*GF;
				s.getRobot().setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(s.getAbsBearing()-s.getRobot().getGunHeadingRadians()+angleOffset));
			}
			else
				s.getRobot().setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(s.getAbsBearing()-s.getRobot().getGunHeadingRadians()));
			
		}		
		if (s.getRobot().getGunTurnRemaining()==0&&s.getRobot().getGunHeat()==0&&bulletPower>0) {
			if ((s.getRobot().setFireBullet(bulletPower)) != null &&
					s.getEnemyEnergy() > 0) {
				waves.setReal(-1);
			}
		}
		BufferWrapper a = new BufferWrapper(currentStats,5,1);
		BufferWrapper b = new BufferWrapper(fastStats,3,1);
		BufferWrapper c = new BufferWrapper(rawStats,1,0.95);
		w.buffers = new ArrayList();
		w.buffers.add(a);
		w.buffers.add(b);
		w.buffers.add(c);
		
		waves.add(w);
		
	}
	
}
