package dft.bin;

import java.awt.geom.Point2D;

public class ReducedState {

	private double absBearing;
	
	private double enemyBearing;
	private double enemyHeading;
	private double enemyVelocity;
	private double enemyLateralVelocity;
	private double enemyDirection;
	private double enemyEnergy;
	
	private Point2D enemyLocation;
	private Point2D robotLocation;
	
	private double robotDirection;
	private double robotLateralVelocity;
	private double robotVelocity;
	
	private long time;
	private int round;
	
	public ReducedState(State s) {		
		absBearing = s.getAbsBearing();
		enemyBearing = s.getEnemyBearing();
		enemyVelocity = s.getEnemyVelocity();
		enemyLateralVelocity = s.getEnemyLateralVelocity();
		enemyEnergy = s.getEnemyEnergy();
		enemyLocation = s.getEnemyLocation();
		robotLocation = s.getRobotLocation();
		enemyDirection = s.getEnemyDirection();
		robotLateralVelocity = s.getRobotLateralVelocity();
		robotVelocity = s.getRobotVelocity();
		robotDirection = s.getRobotDirection();
		time = s.getTime();
		round = s.getRobot().getRoundNum();
	}
	
	public double getRobotVelocity() {
		return robotVelocity;
	}
	
	public double getAbsBearing() {
		return absBearing;	
	}
	
	public double getEnemyDirection() {
		return enemyDirection;
	}
	
	public double getEnemyBearing() {
		return enemyBearing;
	}
	
	public double getEnemyHeading() {
		return enemyHeading;
	}
	
	public double getEnemyVelocity() {
		return enemyVelocity;
	}
	
	public double getEnemyEnergy() {
		return enemyEnergy;
	}
	
	public double getEnemyLateralVelocity() {
		return enemyLateralVelocity;
	}
	
	public double getRobotLateralVelocity() {
		return robotLateralVelocity;
	}
	
	public double getRobotDirection() {
		return robotDirection;
	}
	
	public Point2D getEnemyLocation() {
		return enemyLocation;
	}
	
	public Point2D getRobotLocation() {
		return robotLocation;
	}
	
	public long getTime() {
		return time;
	}
	
	public int getRound() {
		return round;
	}
	
}
