package nat.micro;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/**
 * Reepicheep
 * 
 * A micro-bot by Nat Pavasant. It uses Random/Stop-N-Go multi-mode with
 * GuessFactor targeting gun,
 * 
 * Gun base on Falcon, by PEZ and Kawigi and Komarious by Voidious; Movement
 * based on OcnirpSNG by Nat Pavasant.
 */
public class Reepicheep extends AdvancedRobot {
	static final double HALF_PI = 1.5707963267948966192313216916398;
	
	// //////////////////////////////////////////
	// Falcon's Gun
	
	static final double BULLET_POWER = 2.5; // 2.5 is the best by the way =)
	static final double BULLET_VELOCITY = 12.5; // bullet velocity for 2.5-size
	// bullet
	
	static final int BINS = 31; // 31 bins is fine for non-smoothed array.
	static final int MIDDLE_BIN = 15; // middle bin
	static final double MEA = 0.694498266 / MIDDLE_BIN; // hard-coded for 2.5
	// bullet power
	
	static double _enemyX; // enemy location
	static double _enemyY; // enemy location
	static int _enemyDirection;
	
	static final Rectangle2D.Double fieldRect = new Rectangle2D.Double(18, 18,
			764, 564);
	
	static double distance;
	
	// Gun stats
	static int[][][][] _gunStats = new int[6][4][2][BINS];
	//static int[][][][][] _gunStats = new int[6][4][2][13][BINS];
	
	// Gun
	// //////////////////////////////////////////
	
	// //////////////////////////////////////////
	// Movement
	
	// Distance controller constant
	static double PREFERRED_DISTANCE = 375d;
	
	// Multimode constant
	static final int DEATH_FACTOR = 3;
	
	static double _moveFactor = 1;
	static double _enemyEnergy; // keep track of enemy energy
	static boolean random = false;
	static int death;
	
	public void run() {
		_enemyDirection = 1;
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		
		do {
			turnRadarRightRadians(1);
		} while (true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		Wave wave;
		double enemyAbsoluteBearing, enemyLatVel;
		int mostVisited = MIDDLE_BIN, i = BINS, direction;
		
		// /////////////////////////////////////
		// GuessFactor targeting gun
		// Base loosely on Falcon gun.
		//
		addCustomEvent(wave = new Wave());
		
		_enemyX = (wave.wGunX = getX())
				+ Math.sin(enemyAbsoluteBearing = e.getBearingRadians()
						+ getHeadingRadians()) * (distance = e.getDistance());
		_enemyY = (wave.wGunY = getY()) + Math.cos(enemyAbsoluteBearing)
				* distance;
		
		// check for enemy movement direction, preserve old direction if current
		// velocity is 0
		if ((direction = (int) Math.signum(enemyLatVel = e.getVelocity()
				* Math.sin(e.getHeadingRadians()
						- (wave.wBearing = enemyAbsoluteBearing)))) != 0)
			_enemyDirection = direction;
		
		// Segment: lateralVelocity, forwardWall and reverseWall
		wave.stats = _gunStats[(Math.abs(enemyLatVel) >= 7.75) ? 4 : (int) (1.4427 * Math
				.log(Math.abs(enemyLatVel) + 1.75))][gunWallDistance(
				0.18247367367, enemyAbsoluteBearing) ? (gunWallDistance(
				0.36494734735, enemyAbsoluteBearing) ? (gunWallDistance(
				0.63865785787, enemyAbsoluteBearing) ? 3 : 2) : 1) : 0][gunWallDistance(
				-0.36494734735, enemyAbsoluteBearing) ? 0 : 1]/*[(int)distance / 100]*/;
		
		do {
			if (wave.stats[--i] > wave.stats[mostVisited])
				mostVisited = i;
		} while (i > 0);
		
		setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing
				- getGunHeadingRadians()
				+ (wave.wBearingDirection = (MEA * _enemyDirection))
				* (mostVisited - MIDDLE_BIN)));
		wave.weight = setFireBullet(BULLET_POWER) != null ? 4 : 1;
		// /////////////////////////////////////////
		
		// /////////////////////////////////////////
		// Narrow Lock Radar
		setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing
				- getRadarHeadingRadians()) * 2);
		// /////////////////////////////////////////
		
		// /////////////////////////////////////
		// Stop-n-go/Random multi-mode movement
		// Based on OcnirpSNG
		//
		
		// Turn Perpendicular with distance controller and wall smoother
		// enemyLatVel to store temporary data
		double offset = Math.min(1.5, Math.max(PREFERRED_DISTANCE
				/ distance, 0.5))
				* HALF_PI;
		while (!fieldRect.contains(getX()
				+ 140
				* Math.sin(enemyLatVel = enemyAbsoluteBearing + _moveFactor
						* (offset -= .02)), getY() + 140
				* Math.cos(enemyLatVel)))
			;
		
		if (!random) {
			enemyLatVel = enemyAbsoluteBearing + _moveFactor * HALF_PI;
		} else if (Math.random() > 0.92) {
			// onHitWall(null);
			_moveFactor = -_moveFactor;
		}
		
		setTurnRightRadians(Math.tan(enemyLatVel - getHeadingRadians()));
		
		if (random || _enemyEnergy > (_enemyEnergy = e.getEnergy())) {
			setAhead(37 * Math.signum(Math.cos(enemyLatVel)));
		}
		
		// /////////////////////////////////////
	}
	
	static class Wave extends Condition {
		double wGunX;
		double wGunY;
		double wBearing;
		double wBearingDirection;
		double wDistance;
		int weight;
		int[] stats;
		
		public boolean test() {
			if (Math.abs((wDistance += BULLET_VELOCITY)
					- Point2D.distance(wGunX, wGunY, _enemyX, _enemyY)) <= BULLET_VELOCITY / 2) {
				stats[(int) ((Utils.normalRelativeAngle(Math.atan2(_enemyX
						- wGunX, _enemyY - wGunY)
						- wBearing)) / wBearingDirection)
						+ MIDDLE_BIN] += weight;
				// removeCustomEvent(this);
			}
			
			return false;
		}
	}
	
	public void onBulletHit(BulletHitEvent e) {
		_enemyEnergy -= 13d;
	}
	
	public void onHitWall(HitWallEvent e) {
		if (!random)
			_moveFactor = -_moveFactor;
	}
	
	public void onDeath(DeathEvent e) {
		//if (getRoundNum() < DEATH_FACTOR)
		if (++death >= DEATH_FACTOR)
			random = true;
		
		// Nano-size dynamic distancing
		// (19 bytes)
		// PREFERRED_DISTANCE = 200d + Math.random() * 200d;
	}
	
	// inject the absBearing here is good since it on the register, but inject
	// the distance isn't good since it out of register now.
	private static boolean gunWallDistance(double wallDistance, double ab) {
		double angle;
		return fieldRect.contains(_enemyX
				+ Math.sin(angle = ab + (_enemyDirection * wallDistance))
				* distance, _enemyY + Math.cos(angle) * distance);
	}
}
