/*
 * Created on Jun 14, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package jekl.utils;

import robocode.util.Utils;
import java.awt.geom.*;
import java.text.NumberFormat;

import jekl.*;

/**
 * @author Jim
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Wave implements Constants {
	public Point2D.Double shotOrigin;
	public Point2D.Double targetLoc;
	Enemy target;
	public double shotPower;
	public double bulletVel;
	public double dist;
	public double startingAbsTargetBearing;
	public double maxAnglePossible;
	public float[] guessFactors;
	public float[] fastBuff;
	public int wDirection;
	public double botWidth;
	private JeklUtils u;
	public int id;
	public int distIndex;
	private DarkHallow ar;
	private NumberFormat nf;
        
	public Wave(DarkHallow _ar) {
		this.ar = _ar;
		this.nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits(3);
	}

	public void initializeWave(double firePower, float[] stats, float[] fastBuffer, Point2D.Double origin, 
			Point2D.Double _targetLoc, int ticks, int shotDir, int _distIndex) {
		guessFactors = stats;
		fastBuff = fastBuffer;
		wDirection = shotDir;
		shotPower = firePower;
		bulletVel = JeklUtils.bulletV(firePower);
		dist += (bulletVel * ticks);
		shotOrigin = new Point2D.Double(origin.x, origin.y);
		targetLoc = _targetLoc;
		startingAbsTargetBearing = JeklUtils.getAbsBearing(origin, targetLoc);
		maxAnglePossible = Math.asin(8.0 / bulletVel) * shotDir;
		distIndex = _distIndex;
	}

	//Returns the successful guess factor
	public int getGuessFactor() {
		double currentAbsBearingFromShotOrigin = JeklUtils.getAbsBearing(shotOrigin, targetLoc);
		return (int) Math.max(0,Math.min((GUESS_FACTORS - 1),(int) Math.round(((((Utils.normalRelativeAngle(JeklUtils.getAbsBearing(shotOrigin, targetLoc) - startingAbsTargetBearing)) / maxAnglePossible) * MIDDLE_FACTOR) + MIDDLE_FACTOR))));
	}


	//Adapted from Butterfly
	public Point2D.Double predictImpactLocation(int testDir, int cDir, double maxVelocity) {
		int retVal = 0;
		Point2D.Double impactLoc = new Point2D.Double(ar.getX(), ar.getY());
		double travelDist = dist;
    	double velocity = Math.abs(ar.getVelocity()) * cDir;
    	double heading = ar.getHeadingRadians();

		do {
			//Figure the bearing of movement and max turn radius
			double bearing = Utils.normalRelativeAngle(JeklUtils.getAbsBearing(impactLoc, ar.getDestination(impactLoc, testDir, WALL_CURVE_DISTANCE)));
			heading += backAsFrontDirection(bearing, heading) < 0 ? Math.PI : 0.0;
			double maxTurn = Math.toRadians(10.0D - 0.75 * Math.abs(velocity));
			heading += JeklUtils.minMax(backAsFrontTurn(bearing, heading), -maxTurn, maxTurn);
			//Project the movement
			impactLoc.setLocation(impactLoc.x + (Math.sin(heading) * Math.abs(velocity)), impactLoc.y + (Math.cos(heading) * Math.abs(velocity)));
			//Now deal with acceleration
			velocity = JeklUtils.minMax(velocity + (velocity * testDir >= 0 ? testDir : 2 * testDir),-maxVelocity, maxVelocity);
		} while ((travelDist += bulletVel) <= (shotOrigin.distance(impactLoc) - 18));
		return impactLoc;
	}

	public double predictDanger(Point2D.Double impactLoc, Point2D.Double dest) {
		double retVal = 0.0;
		int smoothValue = 1;
		//int smoothValue = Math.max(1,(int)Math.ceil(Math.atan(18d / shotOrigin.distance(targetLoc))*(GUESS_FACTORS - 1)));

		Point2D.Double myLocation = new Point2D.Double(ar.getX(), ar.getY());
		int predictedGF = (int) Math.max(0.0, Math.min((GUESS_FACTORS - 1), (int) Math.round(((((Utils.normalRelativeAngle(JeklUtils.getAbsBearing(shotOrigin, impactLoc) - startingAbsTargetBearing)) / maxAnglePossible) * MIDDLE_FACTOR) + MIDDLE_FACTOR))));
		for (int j = Math.max(1, (predictedGF - smoothValue)); j <= Math.min(GUESS_FACTORS - 1, predictedGF + smoothValue); j++) {
			//retVal += ((double)guessFactors[j]) + ((double)fastBuff[j]) * (1 + Math.cos(Math.abs(ar.getTarget().getAbsBearing() - JeklUtils.getAbsBearing(myLocation, ar.getTarget().getLocation()))));//adjusted for "perpendicularity"
			retVal += ((double)guessFactors[j]) + ((double)fastBuff[j]);
		}
		return ((double) retVal / Math.pow((shotOrigin.distance(targetLoc) - dist), 2));
	}

	public void incrementHits() {
		//int smooth = 1;
		int smooth = Math.max(1,(int)Math.ceil(Math.atan(18d / shotOrigin.distance(targetLoc))*(GUESS_FACTORS - 1)));
		float FULL_DEPTH = 1;
		float FAST_DEPTH = 5;
		for (int i = 0; i < GUESS_FACTORS - 1; i++) {
			if (i >= getGuessFactor() - smooth && i <= getGuessFactor() + smooth) {
				guessFactors[i] = JeklUtils.rollingAverage(FULL_DEPTH, guessFactors[i], 5F);
				fastBuff[i] = JeklUtils.rollingAverage(FAST_DEPTH,fastBuff[i], 3F);
			} else {
				guessFactors[i] = JeklUtils.rollingAverage(FULL_DEPTH,guessFactors[i], 0F);
				fastBuff[i] = JeklUtils.rollingAverage(FAST_DEPTH,fastBuff[i], 0F);
			}
		}
	}
	
	public void incrementGunHits() {
		guessFactors[0]++;
		fastBuff[0]++;
		int incBuffer = getGuessFactor();
		guessFactors[incBuffer]++;
		fastBuff[incBuffer]++;
	}

	//Lifted from Butterfly
    public static double backAsFrontTurn(double newHeading, double oldHeading) {
    	return Math.tan(newHeading - oldHeading);
    }

	//Lifted from Butterfly
    public static double backAsFrontDirection(double newHeading, double oldHeading) {
    	return JeklUtils.sign(Math.cos(newHeading - oldHeading));
    }
	
	public void debug () {
		System.out.println("Shot Power: " + shotPower);
		System.out.println("Velocity: " + bulletVel);
		System.out.println("Dist: " + dist);
		System.out.println("SABS: " + startingAbsTargetBearing);
		System.out.println("MAP: " + maxAnglePossible);
		System.out.println("AIA: " + JeklUtils.getAbsBearing(shotOrigin, targetLoc));
		System.out.println("WDIR: " + wDirection);
	}
}