package sch;

import robocode.*;
/**
 * A library containing all utility functions used by bot's actions
 */
public final class BotUtil implements Constants {


	/**
	 * Aling a string so that it can be used in a fixed length space
	 * @param	str	the string to be formatted
	 * @param	lung	the length of the space
	 * @param	align	the aligment that should be used
	 * @return		the aligned string
	 */
	static String makeFixedLength(String str, int lung, int align) {

		String finalStr="";
		int emptySpace=0;

		if (str.length()<lung) {
			finalStr=new String(str);
			emptySpace=lung-str.length();
			if (align==ALIGN_LEFT){
				for(int i=0;i<emptySpace;i++)
					finalStr+=" ";
			}
			else if (align==ALIGN_CENTER){
				for(int i=0;i<emptySpace/2;i++)
					finalStr+=" ";
				for(int i=0;i<emptySpace/2;i++)
					finalStr=" "+finalStr;				
			}
			else if (align==ALIGN_RIGHT){
				for(int i=0;i<emptySpace;i++)
					finalStr=" "+finalStr;				
			}
		}
		else if (str.length()>lung)
			finalStr=str.substring(0,lung-1);

		if (finalStr.length()<lung)
			finalStr=" "+finalStr;

		return finalStr;
	}
	
	/**
	 * Verify if a certain bit (represented by its decimal representation) is set to 1 in a binary variable (represented by its decimal representation)
	 * @param	variable	the containing variable
	 * @param	neededVar	the needed variable
	 * @return				a boolean
	 */
	static boolean varContains(int variable, int neededVar) {
		if ((neededVar%2!=0 && neededVar!=1) || neededVar>variable)
			return false;
		String binString=Integer.toBinaryString(variable);
		String neededVarStr=Integer.toBinaryString(neededVar);
		int varBit=neededVarStr.length();
		
		return (binString.charAt(binString.length()-varBit)=='1');
	}
	
	/**
	 * Verify is a point is out of the battlefield bounds
	 * @param	myBot	the reference to my bot
	 * @param	p		the point to be verified
	 * @return			True if the point is out of bounds
	 */
	static boolean isOutOfBattleFieldBounds(AdvancedRobot myBot, Point p){
		double fieldWidth=myBot.getBattleFieldWidth();
		double fieldHeight=myBot.getBattleFieldHeight();
		if (p.x<0 || p.x>fieldWidth || p.y<0 || p.y>fieldHeight)
			return true;
		else
			return false;
	}
	
}