package ags.util;

import java.util.Arrays;

public class AuxiliaryDataHolder {
    private static final int DEFAULT_ARRAY_SIZE = 2;
    private Object[] objs = new Object[DEFAULT_ARRAY_SIZE];
    private int objCount = 0;
    
    @SuppressWarnings("unchecked")
    public <T> T getAuxiliaryData(Class<T> clazz) {
        for (int i = 0; i < objCount; i++) {
            if (clazz == objs[i].getClass()) {
                return (T) objs[i];
            }
        }
        return null;
    }
    
    public void setAuxiliaryData(Object data) {
        // Replace existing object if there is one
        for (int i = 0; i < objCount; i++) {
            if (data.getClass() == objs[i].getClass()) {
                objs[i] = data;
                return;
            }
        }
        // Otherwise add it to the list
        if (objCount >= objs.length) {
            // Extend if necessary
            objs = Arrays.copyOf(objs, objs.length*2);
        }
        objs[objCount] = data;
        objCount++;
    }
}
