package romz.math;

import java.awt.geom.Point2D;

import robocode.Rules;
import robocode.util.Utils;

public class RobotMath {

	public static double sin(double angleInDegrees) {
		return Math.sin(Math.toRadians(angleInDegrees));
	}
	
	public static double cos(double angleInDegrees) {
		return Math.cos(Math.toRadians(angleInDegrees));
	}
	
	public static double asin(double a) {
		return Math.toDegrees(Math.asin(a));
	}
	
	public static double atan(double a) {
		return Math.toDegrees(Math.atan(a));
	}
	
	public static double random() {
		return Math.random();
	}
	
	public static double abs(double a) {
		return Math.abs(a);
	}
	
	public static double signum(double d) {
		return Math.signum(d);
	}
	
	public static int round(double d) {
		return (int) Math.round(d);
	}
	
	public static double limit(double a, double x, double b) {
		return max(a, min(x, b));
	}
	
	public static double min(double a, double b) {
		return Math.min(a, b);
	}
	
	public static double max(double a, double b) {
		return Math.max(a, b);
	}
	
	public static double heading(double x1, double y1, double x2, double y2) {
		double x = x2 - x1;
		double y = y2 - y1;
		double trigonometricAngle = Math.toDegrees(Math.atan2(y, x));
		return Utils.normalAbsoluteAngleDegrees(90 - trigonometricAngle);
	}
	
	public static double distance(double x1, double y1, double x2, double y2) {
		return Point2D.Double.distance(x1, y1, x2, y2);
	}
	
	public static double maxEscapeAngle(double firePower) {
		return asin(Rules.MAX_VELOCITY / Rules.getBulletSpeed(firePower));
	}
	
	/** Returns 1 for a clockwise direction, -1 for counter-clockwise */
	public static double direction(double heading, double bearing) {
		return signum(sin(heading - bearing));
	}
	
	public static double headingAlignment(double heading, double bearing) {
		return abs(sin(heading - bearing));
	}
	
}
