package pl.Abstract;

/*******************************************************************************
 * An abstract class for robots using Strategies. It conveniently defines a
 * static Strategy named strategy (this must be initialized to an actual
 * Strategy in the extending robot's run() method) and overrides all usual
 * Robocode event-handling methods by calling the corresponding method of the
 * Strategy. Furthermore, this class does not define a run() method publicly. It is
 * up to the writer of any robot extending this to manually write the run()
 * method, and to initialize strategy.
 * 
 * @see Strategy
 ******************************************************************************/
public abstract class StrategyUsingRobot extends robocode.AdvancedRobot {

	/**
	 * The Strategy to be used by any class extending StrategyUsingRobot.
	 */
	public static Strategy strategy;

	/**
	 * {@inheritDoc}
	 */
	public abstract void run();

	/**
	 * {@inheritDoc}
	 */
	public void onScannedRobot(robocode.ScannedRobotEvent e) {
		strategy.onScannedRobot(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onRobotDeath(robocode.RobotDeathEvent e) {
		strategy.onRobotDeath(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onHitByBullet(robocode.HitByBulletEvent e) {
		strategy.onHitByBullet(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onHitRobot(robocode.HitRobotEvent e) {
		strategy.onHitRobot(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onHitWall(robocode.HitWallEvent e) {
		strategy.onHitWall(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onWin(robocode.WinEvent e) {
		strategy.onWin(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onDeath(robocode.DeathEvent e) {
		strategy.onDeath(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onBulletHit(robocode.BulletHitEvent e) {
		strategy.onBulletHit(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onBulletMissed(robocode.BulletMissedEvent e) {
		strategy.onBulletMissed(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onBulletHitBullet(robocode.BulletHitBulletEvent e) {
		strategy.onBulletHitBullet(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onCustomEvent(robocode.CustomEvent e) {
		strategy.onCustomEvent(e);
	}

	/**
	 * {@inheritDoc}
	 */
	public void onPaint(java.awt.Graphics2D g) {
		strategy.onPaint(g);
	}
}