package zyx.mega.utils.wave;

import zyx.mega.geometry.Point;
import zyx.mega.movement.WaveSurfing;
import zyx.mega.utils.Snapshot;
import zyx.mega.utils.Wave;
import zyx.simonton.utils.Cluster;

public class SurfingWave extends Wave {

  public Cluster<Snapshot> hit_cluster_[];
  public Cluster<Snapshot> flat_cluster_[];

  @SuppressWarnings("unchecked")
  public SurfingWave(Point center) {
    super(center);
    hit_cluster_ = new Cluster[WaveSurfing.NUM_DISTANCERS];
    flat_cluster_ = new Cluster[WaveSurfing.NUM_DISTANCERS];
  }
  public SurfingWave(SurfingWave wave) {
    super(wave);
    hit_cluster_ = wave.hit_cluster_;
    flat_cluster_ = wave.flat_cluster_;
  }
}
