package cs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import robocode.*;
import robocode.util.Utils;

public final class Wren extends AdvancedRobot {
	static final int AIM_START = 10;
	static final double AIM_FACTOR = 1.008;
	
	static HashMap<String,Point2D.Double> map = new HashMap<String,Point2D.Double>();
	static Rectangle2D field;
	static Point2D lastTarget;
	static double lastDistance;
	public void run() {
		field = new Rectangle2D.Double(40,40,getBattleFieldWidth()-80,getBattleFieldHeight()-80);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		setAllColors(Color.decode("#EDB2CA"));
		
		while(true)
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}
	
	private Point2D.Double project(Point2D.Double src, double angle, double dist) {
		return new Point2D.Double(src.x+Math.sin(angle)*dist,src.y+Math.cos(angle)*dist);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double dist, tgAgl;
		Point2D.Double p = new Point2D.Double(getX(),getY());
		map.put(e.getName(), project(p,tgAgl = getHeadingRadians() + e.getBearingRadians(), dist=e.getDistance()));
		
		if(setFireBullet(1.955) != null) {
			lastDistance = Double.POSITIVE_INFINITY;
		}
		
		//DustBunny gun
		if(lastDistance+100 > dist) {
			lastDistance = dist;
			if(getGunHeat() < 1) {
				setTurnRadarRightRadians(Utils.normalRelativeAngle(tgAgl-getRadarHeadingRadians()));
			}
			
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(tgAgl - getGunHeadingRadians() + 
					(e.getVelocity() / (AIM_START + Math.pow(AIM_FACTOR, dist))) * Math.sin(e.getHeadingRadians() - tgAgl) ));
		}
		
		//movement
		if(lastTarget == null)
			lastTarget = p;
		
		if(getDistanceRemaining() < 20) {
			double bestDanger = 120;
			int n = 200;
			while(n-- > 0) {
				Point2D.Double target = project(p,Math.random()*Math.PI*2,Math.random()*100+50);
				if(!field.contains(target))
					continue;
				double danger = 0;
				try {
					Iterator<Point2D.Double> it = map.values().iterator();
					while(true) {
						Point2D.Double q = it.next();
						danger += 0.1/target.distance(field.getCenterX(),field.getCenterY());
						danger += 1/target.distance(q);
						danger += 1/target.distanceSq(lastTarget);
					}
				} catch(Exception ex) {}
				if(danger < bestDanger) {
					bestDanger = danger;
					lastTarget = target;
					goTo(target.x,target.y);
				}
			}
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		map.remove(e.getName());
	}
	
	private void goTo(double x, double y) {
	    double a;
	    setTurnRightRadians(Math.tan(
	        a = Math.atan2(x -= getX(), y -= getY())
	              - getHeadingRadians()));
	    setAhead(Math.hypot(x, y) * Math.cos(a));
	}
}
