package qualidafial;

import static java.lang.Double.NaN;
import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Double.isNaN;
import static java.lang.Math.abs;
import static java.lang.Math.min;
import static java.lang.Math.signum;
import static java.lang.Math.tan;
import static robocode.util.Utils.normalAbsoluteAngle;
import static robocode.util.Utils.normalRelativeAngle;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

public class MajorDick extends AdvancedRobot {

	private static final double RADAR_OVERSWEEP = Math.PI / 8;

	private static final double WALL_BUFFER = 50;

	private double maxTargetError;

	private double targetHeading = Double.NaN;
	private double targetDistance = Double.NaN;

	private double velocity = 1;
	private double rotation = 1;

	@Override
	public void run() {
		maxTargetError = min(getWidth(), getHeight()) / 4;

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);

		setTurnLeftRadians(getHeadingRadians());

		execute();

		while (true) {
			double radarTurn = normalRelativeAngle(targetHeading
					- getRadarHeadingRadians());
			radarTurn += signum(radarTurn) * RADAR_OVERSWEEP;

			double gunTurn = normalRelativeAngle(targetHeading
					- getGunHeadingRadians());

			double tankTurn = rotation * Math.PI;

			if (nearWall()) {
				if (rotation != 0) {
					velocity = -velocity;
					rotation = 0;
				}
			} else if (rotation == 0) {
				rotation = 1;
			}

			if (isNaN(targetHeading)) {
				radarTurn = POSITIVE_INFINITY;
			}

			if (!nearWall() && isNaN(targetDistance) || targetDistance > 300) {
				// chase
				tankTurn = normalRelativeAngle(targetHeading
						- getHeadingRadians());

				if (abs(tankTurn) <= Math.PI / 2) {
					velocity = 1;
				} else {
					velocity = -1;
					tankTurn = normalRelativeAngle(3 * Math.PI * tankTurn);
				}

				tankTurn += signum(tankTurn) * Math.PI / -4;
			}

			if (getGunHeat() == 0.0 && targetDistance < 200
					&& targetDistance * abs(tan(gunTurn)) < maxTargetError) {
				setFire(3);
			}

			setAhead(1000 * velocity);
			setTurnRightRadians(tankTurn);
			setTurnGunRightRadians(gunTurn);
			setTurnRadarRightRadians(radarTurn);

			execute();
		}
	}

	private boolean nearWall() {
		return Math.min(getX(), getBattleFieldWidth() - getX()) < WALL_BUFFER
				|| Math.min(getY(), getBattleFieldHeight() - getY()) < WALL_BUFFER;
	}

	@Override
	public void onStatus(StatusEvent e) {
		targetDistance *= .9;
		if (targetDistance < 200) {
			targetDistance = NaN;
			targetHeading = NaN;
		}
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent event) {
		double heading = normalAbsoluteAngle(getHeadingRadians()
				+ event.getBearingRadians());
		double distance = event.getDistance();

		if (isNaN(targetDistance) || distance < targetDistance) {
			targetHeading = heading;
			targetDistance = distance;
		}
	}

	@Override
	public void onHitWall(HitWallEvent event) {
		velocity = -velocity;
		rotation = 0;
	}

	@Override
	public void onHitRobot(HitRobotEvent event) {
		velocity = -velocity;
	}

	@Override
	public void onHitByBullet(HitByBulletEvent event) {
		rotation = -rotation;
	}
}
