package dsekercioglu.mega.wfGun.gun;

import dsekercioglu.mega.WFData;
import dsekercioglu.mega.WFDataSaver;
import dsekercioglu.mega.megaCore.KNNPredictor;
import dsekercioglu.mega.wfGun.GunUtils;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;

public class AntiAdaptiveGun extends AbstractPredictor {

    private final KNNPredictor PREDICTOR;
    public final int BINS;
    public final int K = 38;
    public final int SIZE_DIVIDER = 2;
    
    ArrayList<double[]> inputs = new ArrayList<>();
    ArrayList<Integer> outputs = new ArrayList<>();
    ArrayList<Double> botWidths = new ArrayList<>();

    public long id;

    // 50.27072176971326, 1.2783370487552164
    public AntiAdaptiveGun(int bins) {
        id = System.currentTimeMillis();
        BINS = bins;
        PREDICTOR = new KNNPredictor();
//88.82101574166785, 3.88823336915957
        //PREDICTOR.setup(new double[]{1.4431060885893576, 8.242521075992853, 9.081910136444218, 10, 9.1, 8.520712286546207, 5.24736322357048, 0.793994926881223, 3.79806180503922, 4.79680315498041, 0.9804750238104654, 0.09523156240435438}, K, BINS, MANHATTAN, PREDICTOR.divisionK(K, SIZE_DIVIDER));
        PREDICTOR.setup(new double[]{9.92, 4.49, 8.8, 8.76, 5.79, 0.8, 7.8, 4.89, 9.5, 8.27, 6.89, 0.033}, K, BINS, PREDICTOR.divisionK(K, SIZE_DIVIDER));
    }

    public double[] predict(double[] data) {
        return GunUtils.normalizeBinValues(PREDICTOR.predictBins(data));
    }

    public void wavePassed(double[] data, int bin, boolean real, double botWidth) {
        if (real) {
            inputs.add(data);
            outputs.add(bin);
            botWidths.add(botWidth);
            PREDICTOR.addData(data, bin, 1);
        }
    }

    public String getName() {
        return "Anti-Adaptive Gun";
    }

    @Override
    public void onMatchEnded(AdvancedRobot r) {

        String name = WFDataSaver.enemyName;
        writeObject(inputs, name + id + "inputs", r);
        writeObject(outputs, name + id + "outputs", r);
        writeObject(botWidths, name + id + "botwidths", r);
    }

    public void writeObject(Serializable obj, String filename, AdvancedRobot r) {
        try {
            System.out.println(r.getDataFile(filename + ".zip"));
            ZipOutputStream zipout = new ZipOutputStream(
                    new RobocodeFileOutputStream(r.getDataFile(filename + ".zip")));
            zipout.putNextEntry(new ZipEntry(filename));
            ObjectOutputStream out = new ObjectOutputStream(zipout);
            out.writeObject(obj);
            out.flush();
            zipout.closeEntry();
            out.close();
        } catch (IOException e) {
            System.out.println("Error writing Object:" + e);

        }
    }
}
