package tzu.gun;
import tzu.util.*;
import tzu.intel.*;

/**
 * Provides predictive aiming using previous specified reaction to fire.
 */
public class PredictAim implements Constants {

    /**
     * Given an enemy bot target, it's previous reaction to being fired
     * at, and bullet motion, returns a FireSolution that will allow the
     * bullet to hit the target, provided the target reacts the exact same
     * way when it's fired at.
     *
     * @return FireSolution or null if no reasonable solution found.
     */
    public static FireSolution calculate(
            Bot target,
            Reaction r,
            Motion bullet) {

        Motion targetMotion = new Motion(
            target.getX(),
            target.getY(),
            r.getHeading(target.getBearing()),
            r.getSpeed(),
            0,0);

        targetMotion.setBot(target);

        FireSolution fs = EstimateAim.calculate(targetMotion, bullet);
        if (fs != null) {
            fs.setMethod(fs.AIM_PREDICTED);
        }
        return fs;
    }
}

