package shinh;

import robocode.*;

public class FireOne extends Fire {
	private Entangled ent;

	private int wait_ = 20;
	private int tease_ = 0;

	public FireOne() {
		ent = Entangled.me;
	}

	public void teaseCount() {
		if (tease_ > 600) {
			tease_ = -1;
		}
		else {
			tease_++;
		}
	}

	public void goTease() {
		tease_ = 0;
	}

	public void update() {
		if (ent.target != null) {
			if (tease_ != -1 &&
				ent.target.energy <= 0.3 &&
				ent.getEnergy() > ent.target.energy * 20)
			{
				teaseCount();
				double r = Util.getNormalRadian(
					(ent.getGunHeadingRadians() - ent.target.radian));
				ent.setTurnGunLeftRadians(r);
				return;
			}

			if (ent.target.distance < Const.ULTRA_APPROACH_ENEMY) {
				double r = Util.getNormalRadian(
					(ent.getGunHeadingRadians() - ent.target.radian));
				ent.setTurnGunLeftRadians(r);
				if (Math.abs(r) < Const.PI_4) ent.setFire(3);
				return;
			}

			double pow = 3;
/*
			if (tease_ != -1 &&
				((ent.target.energy < 16 && ent.getEnergy() > 70) ||
				 (ent.target.energy * 2 < ent.getEnergy() &&
				  ent.getEnergy() > 30 &&
				  ent.target.predictor.getPercent() > 40)))
			{
				teaseCount();
				wait_--;
				if (wait_ <= 0) {
					pow = Util.getPowerFromDamage(ent.target.energy * 0.5);
					wait_ = 20;
				}
				else {
					double r = Util.getNormalRadian(
						(ent.getGunHeadingRadians() - ent.target.radian));
					ent.setTurnGunLeftRadians(r);
					return;
				}
			}
			else
*/
			if (ent.getEnergy() <= 0.1) {
				double r = Util.getNormalRadian(
					(ent.getGunHeadingRadians() - ent.target.radian));
				ent.setTurnGunLeftRadians(r);
			}
			else if (ent.getEnergy() <= 0.3) {
				if (ent.target.energy > 1) {
					double r = Util.getNormalRadian(
						(ent.getGunHeadingRadians() - ent.target.radian));
					ent.setTurnGunLeftRadians(r);
					return;
				}
				else {
					pow = 0.1;
				}
			}
			else if (ent.getEnergy() < 2) {
				pow = 0.1;
			}
			else if (ent.getEnergy() < 30) {
				if (ent.getEnergy() > 20 &&
					ent.target.predictor.getPercent() > 20)
					pow = 3;
				else
					pow = (double)ent.getEnergy() / 10;
			}

			if (ent.target.distance > 300) {
				pow *= 300 / ent.target.distance;
			}

			if (pow >= 3) {
				pow = 3;
			}
			else if (pow < 0.1) {
				if (ent.getEnergy() > 20) pow = 1;
				else pow = 0.1;
			}

			double r = Util.getNormalRadian(
				(ent.getGunHeadingRadians() - ent.target.getFutureAim(pow)));
			double ar = Math.abs(r);
			ent.setTurnGunLeftRadians(r);

			double epsiron = 0.1;
			if (ent.getEnergy() < 16) {
				epsiron = ent.getEnergy() * 0.005 + 0.02;
			}

			if (ar < epsiron && ent.getGunHeat() == 0 &&
				ent.target.predictor.isValid())
			{
				Bullet b = ent.setFireBullet(pow);
				if (b != null) ent.registBullet(b);
			}
		}
	}

}

