package theo.avenge.utils;
import theo.avenge.wave.Wave;
import java.awt.geom.*;
import java.util.*;
import robocode.*;
import robocode.util.Utils;
/**
 * MyClass - a class by (your name here)
 */
public class WaveUtils
{

	//static final long NUM_NEIGHBORS;
	static List<double[]> solveSet;
	//static List<double[]> keySet;
	static List<Double> nnFactor;
	
	static {
		//NUM_NEIGHBORS = 4;
		solveSet = new ArrayList<double[]>();
		//keySet = new ArrayList<double[]>();
		nnFactor = new ArrayList<Double>();
	}
		
	public double distance(Point2D.Double a, Point2D.Double b){
		return a.distance(b);
	}
	
	public static double distance(double[] a, double[] b){
		double dist = 0;
		for (int i = 0; i < a.length; i ++){
			dist += (a[i]-b[i]) * (a[i]-b[i]);
		}
		return dist;
	}
	
	public static double distance(Object[] a, double[] b){
		double dist = 0;
		for (int i = 0; i < a.length; i ++){
			dist += ((Double)a[i]-b[i])*((Double)a[i]-b[i]);
		}
		return dist;
	}
	
	public static List<Wave> findNearestNeighbors(double[] a, HashMap<double[],Wave> factorMap, long NUM_NEIGHBORS){
		//solveSet.clear(); /*keySet.clear();*/ nnFactor.clear();
		Object[] keySet = factorMap.keySet().toArray();
		List<double[]> solveSet;
		List<Wave> nnFactor;
		solveSet = new ArrayList<double[]>();
		nnFactor = new ArrayList<Wave>();
		/*for(int i = 0; i < factorMap.keySet().size(); i ++){
			keySet.add((double[])factorMap.keySet().toArray()[i]);
		}*/
		int maxIndex = 0;
		double dist = 0, maxDist = 0;
		double tempDist = 0;
		for (int i = 0; i < Math.min(NUM_NEIGHBORS,keySet.length); i ++){
			//double[] neighbor = (double[])keySet.get(i);
			double[] neighbor = (double[])keySet[i];
			nnFactor.add(factorMap.get(neighbor));
			solveSet.add(neighbor);
			if(distance(neighbor,a)>maxDist){
				maxDist = distance(neighbor,a);
				maxIndex = nnFactor.indexOf(factorMap.get(neighbor));
			}
		}
		for(int q = (int)NUM_NEIGHBORS; q < keySet.length; q++){
			//double[] vals = keySet.get(q);
			double[] vals = (double [])keySet[q];
			dist = WaveUtils.distance(vals, a);
			if (dist < maxDist){
				nnFactor.set(maxIndex, factorMap.get(vals));
				solveSet.set(maxIndex, vals);
				tempDist = 0;
				for (int i = 0; i < solveSet.size(); i ++){
					double[] neighbor = solveSet.get(i);
					if(distance(neighbor,a)>tempDist){
						maxDist = distance(neighbor,a);
						tempDist = maxDist;
						maxIndex = i;
					}
				}
			}
		}
		
		//System.out.println("FactorLength " + keySet.length);
		//System.out.println("NSize " + nnFactor.size());
		return nnFactor;
	}
	

	public static List<Double> findNearestSurfNeighbors(double[] a, HashMap<double[],Double> factorMap, long NUM_NEIGHBORS){
		//solveSet.clear(); /*keySet.clear();*/ nnFactor.clear();
		Object[] keySet = factorMap.keySet().toArray();
		List<double[]> solveSet;
		List<Double> nnFactor;
		solveSet = new ArrayList<double[]>();
		nnFactor = new ArrayList<Double>();
		/*for(int i = 0; i < factorMap.keySet().size(); i ++){
			keySet.add((double[])factorMap.keySet().toArray()[i]);
		}*/
		int maxIndex = 0;
		double dist = 0, maxDist = 0;
		double tempDist = 0;
		for (int i = 0; i < Math.min(NUM_NEIGHBORS,keySet.length); i ++){
			//double[] neighbor = (double[])keySet.get(i);
			double[] neighbor = (double[])keySet[i];
			nnFactor.add(factorMap.get(neighbor));
			solveSet.add(neighbor);
			if(distance(neighbor,a)>maxDist){
				maxDist = distance(neighbor,a);
				maxIndex = nnFactor.indexOf(factorMap.get(neighbor));
			}
		}
		for(int q = (int)NUM_NEIGHBORS; q < keySet.length; q++){
			//double[] vals = keySet.get(q);
			double[] vals = (double [])keySet[q];
			dist = WaveUtils.distance(vals, a);
			if (dist < maxDist){
				nnFactor.set(maxIndex, factorMap.get(vals));
				solveSet.set(maxIndex, vals);
				tempDist = 0;
				for (int i = 0; i < solveSet.size(); i ++){
					double[] neighbor = solveSet.get(i);
					if(distance(neighbor,a)>tempDist){
						maxDist = distance(neighbor,a);
						tempDist = maxDist;
						maxIndex = i;
					}
				}
			}
		}
		
		//System.out.println("FactorLength " + keySet.length);
		//System.out.println("NSize " + nnFactor.size());
		return nnFactor;
	}
	
	public static Point2D.Double project(Point2D.Double startPos, double dist, double theta){
		Point2D.Double startCopy = (Point2D.Double)startPos.clone();
		Point2D.Double answer = new Point2D.Double();
		answer.x = startCopy.x + dist * Math.sin(theta);
		answer.y = startCopy.y + dist * Math.cos(theta);
		return answer;
	}

	public static double bSpeed(double pow){
		return (20 - (3 * pow));
	}
	
	public static double absBearing(Point2D.Double start, Point2D.Double target){
		return Utils.normalRelativeAngle(
				Math.atan2((target.x-start.x),(target.y-start.y)));
	}
	
	public static double absAngle(Point2D.Double start, Point2D.Double target){
		return Utils.normalAbsoluteAngle(
				Math.atan2((target.x-start.x),(target.y-start.y)));
	}

	public static double limit(double a, double mid, double b){
		return Math.max(Math.min(b,mid),a);
	}
	
	public static Point2D.Double setCoordinates(double x, double y){
		try{
			return ((Point2D.Double) (new Point2D.Double(x,y).clone()));
		}
		catch(Exception e){
			return new Point2D.Double(x,y);
		}
	}

	public static double square(double a){
		return (a * a);
	}

}
