package davidalves.net.data;

import robocode.*;
import davidalves.net.*;
import davidalves.net.math.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;
/**
 * @author David Alves
 *
 */
public class Statistics implements Serializable {
	
	AbstractAdvancedBot me;
	EnvironmentInterface environment;
	
	double numOpponents;
	double numRounds;
	double skippedTurns;
	long errors = 0;
	long warnings = 0;
		
	//Movement
	double movementCollisionsWithRobots;
	double movementCollisionsWithWalls;
	double movementCollisionsWithBullets;
	
	//Gun
	double gunShotsFired;
	double gunHits;
	double gunMisses;
	
	//Radar
	double radarScannedRobotEvents;



	public Statistics(AbstractAdvancedBot myBot, EnvironmentInterface myEnvironment){
		me = myBot;
		environment = myEnvironment;
	}
	
	public void skippedTurn(){
		skippedTurns++;
	}
	
	public void bulletHit(){
		gunHits++;
	}
	
	public void bulletMiss(){
		gunMisses++;
	}
	
	public void addError(){
		errors++;
	}
	
	public void addWarning(){
		warnings++;
	}
	
	public boolean warningsHaveOccured(){
		return warnings != 0;
	}
	
	public boolean errorsHaveOccured(){
		return errors != 0;
	}
	
	public void printEndOfRoundStatistics(){
		double turns = (double) me.getTime();
		numRounds = me.getNumRounds();
		numOpponents = me.getOthers();
		
		me.out.println("\nStatistics at end of round " + me.getRoundNum());
		me.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
		me.out.print("Accuracy: " + gunHits + "/" + (gunHits + gunMisses));
		me.out.println(" (" + DaveString.formatDouble(100 * gunHits / (gunHits + gunMisses)) + "%)");
		me.out.print("Skipped Turns: " + skippedTurns + "/" + turns);
		me.out.println(" (" + DaveString.formatDouble(100 * skippedTurns / turns) + "%)");
		me.out.println("There " + (warnings==1?"was ":"were ") + warnings + " warning" + (warnings!=1?"s":"") + " and " + errors + " error" + (errors!=1?"s":"")+ " during this round");
		if (errors + warnings > 0)
			me.out.println("See file \"ERRORS.LOG\" for details.");
		me.out.println();
		reset();
	}
	
	public void reset(){
		numOpponents = 0;
		numRounds = 0;
		skippedTurns = 0;
		movementCollisionsWithRobots = 0;
		movementCollisionsWithWalls = 0;
		movementCollisionsWithBullets = 0;
		gunShotsFired = 0;
		gunHits = 0;
		gunMisses = 0;
		radarScannedRobotEvents = 0;
		errors = 0;
		warnings = 0;
	}
	
}
