package davidalves.net.util;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.targeting.*;
import davidalves.net.math.*;
import davidalves.net.movement.*;
import java.util.*;
import java.awt.Color;
import java.io.*;


//A bullet fired by our enemy
public class EnemyBullet implements Serializable{
	double x, y, speed, heading, damage;
	long timeFired;
	
	public EnemyBullet(double angleFired, double power, Point bulletOrigin, long timeItWasFired){//{{{
		speed = 20 - 3 * power;
		x = bulletOrigin.getX();
		y = bulletOrigin.getY();
		heading = angleFired;
		damage = power * 4 + (power > 1 ? (power - 1) * 2 : 0);
		timeFired = timeItWasFired;
	}
	
	public double getDamage(){return damage;}
	
	//Where will the bullet be at time t
	public Point getPosition(long t) {
		double diff = t - timeFired;
		double newY, newX;
		newX = x + DaveMath.xComponent(heading) * speed * diff;
		newY = y + DaveMath.yComponent(heading) * speed * diff;
		return new Point(newX, newY);
	}
}