package cx.utils;
import java.awt.geom.Point2D;
import java.io.Serializable;
import robocode.*;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Infinity Virtule Bullets looks like a wave
 */

public class Wave implements Serializable
{
	//-------comparable varialbles
	public double linePreDiffAngle;
	public double distance;
	public double enemyBearingToCenter;
	//-----------
	public double startX;
	public double startY;
	public long startTime;
	public double absBearing;
	public double velocity;   //in test it is velocity but final it is the distance
	public double power;
	//if willHitDiffAngle==10 means it is testing,==20 means it is useless,others means a succeded wave 
	public double willHitDiffAngle;
	public Wave(double x,double y,double power,long time,double bearing,double dist,double lpda,double enemyBearingToCenter){
		if(power==0){
			velocity=11;
		}else{
    		velocity=20-power*3;
		}
		this.power=power;
		absBearing=bearing;
		distance=dist/90;
        linePreDiffAngle=lpda;
		this.enemyBearingToCenter=enemyBearingToCenter;
		startX=x;
		startY=y;
        startTime=time;

		willHitDiffAngle=10D;//a very max angle show it is not a succeded value
	}
	public static double getComVal(Object o,Object o2,double dir){
		Wave curWave=(Wave)o;
		Wave comWave=(Wave)o2;
        return Math.abs(curWave.linePreDiffAngle-comWave.linePreDiffAngle*dir)
			   +Math.abs(curWave.distance-comWave.distance)
			   +Math.abs(curWave.enemyBearingToCenter-comWave.enemyBearingToCenter);
	}
	public void test(double ex,double ey,long time){
		if(willHitDiffAngle==10D){//it is not a succeded wave,so test
		    double dist=Point2D.distance(startX,startY,ex,ey);
			double travel=velocity*(time-startTime);
			if (travel<0){
				willHitDiffAngle=20D;
			}else if(Math.abs(dist-travel)<18){  //is the wav hit enemy?
				willHitDiffAngle=standardAngle(Math.atan2(ex-startX,ey-startY)-absBearing);
                velocity=dist; //recored distance in velocity
			}
		}
	}
	public static double standardAngle( double ang ) {	//get the relative angle where - PI < angle < PI
		return Math.atan2( Math.sin( ang ), Math.cos( ang ) );
	}
};
