package wilson;

import robocode.*;
import java.util.*;
/**
 * AbstractRobot - difine the structure of my bot and implement some utility elements
 */
public abstract class AbstractRobot extends AdvancedRobot
{
	/*
	 * Contants
	 */
	public final static double WALL_DISTANCE = 35;
	//The following 3 constants are used in virtual bullet targeting
	public final static int DISTANCE_MAX_INDEX = 10; 
	public final static int DELTA_DISTANCE = 100;     
	public final static int FACTOR_MAX_INDEX = 11;
	// the following constants are used in statistic targeting
	public final static int ENTRY_NUMBER = 80;
	
	/*
	 * static fields
	 */
	// the following parameters are used in virtual bullet targeting
	public static int bestFactor = FACTOR_MAX_INDEX/2;
	public static double[][] data = new double[DISTANCE_MAX_INDEX][FACTOR_MAX_INDEX];
	// the following paramenters are used in statistic targeting
	public static HashMap infoData[][][][] = new HashMap[3][3][3][ENTRY_NUMBER];
	// the following paramenters are used in movement
	//public static double[][] avoidAngle = new double[8][3];
	
	/*
	 * the field of the robots
	 */
	//the following parameters are used in virtual bullet targeting
	public double enemyAverageVelocity = 8; //the average velocity of the enemy in recent 
	public boolean isFire;                  //
	public int dIndex;
	public double vFirePower;
	public Vector vBulletList = new Vector();
	//the following parameters are use in statistic targeting
	public Vector enemyInfoList = new Vector();
	// the following parameters are use in movement
	//public Vector enemyBulletList = new Vector();
	// some common info
	public boolean isFound = false;
	public double firePower;
	public double direction = 1;
	protected EnemyInfo nowEnemy = new EnemyInfo();
	
	// initiate
	static	{
		for(int i=0;i<3;i++){
			for (int j=0;j<3;j++){
				for (int k=0;k<3;k++){
					for(int l=0;l<ENTRY_NUMBER;l++){
						infoData[i][j][k][l] = new HashMap();
					}
				}
			}
		}
		for(int i=0;i<DISTANCE_MAX_INDEX;i++){
			for (int j=0;j<FACTOR_MAX_INDEX;j++){
				data[i][j] = 0;
			}
		}
	}
			
	public void reverseDirection() {
		//out.println("reverse direction");
		double distance = getDistanceRemaining() * direction;
		direction *= -1;
		setAhead(distance * direction);
	} 
	
	public void setTurnRightRadiansOptimal(double angle) {
		double turn = Support.normaliseRelativeAngle(angle);
		if (Math.abs(turn) > Support.HALF_PI) {
			reverseDirection();
			if (turn > 0) {
				turn -= Support.PI;
			} else {
				turn += Support.PI;
			}
		}
		setTurnRightRadians(turn);
	}
	
	public double getRelativeHeadingRadians() {
		double relativeHeading = getHeadingRadians();
		if (direction < 0) {
			relativeHeading = Support.normaliseAbsoluteAngle(relativeHeading + Support.PI);
		}
		return relativeHeading;
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		EnemyInfo tempEnemy = (EnemyInfo)nowEnemy.clone();//clone now entry
		//set new infomation
		nowEnemy.name = e.getName();
		nowEnemy.bearing = e.getBearingRadians();
		nowEnemy.absBearing = e.getBearingRadians() + getHeadingRadians();
		nowEnemy.heading = e.getHeadingRadians();
		nowEnemy.cTime = getTime();
		nowEnemy.velocity = e.getVelocity();
		nowEnemy.distance = e.getDistance();
		nowEnemy.x = getX() + e.getDistance()*Math.sin(nowEnemy.absBearing);
		nowEnemy.y = getY() + e.getDistance()*Math.cos(nowEnemy.absBearing);
		nowEnemy.energy = e.getEnergy();
		if (!isFound) {
			isFound = true;
			nowEnemy.headingChange = 0;
			nowEnemy.energyChange = 0;
			nowEnemy.velocityChange = 0;
			nowEnemy.xChange = 0;
			nowEnemy.yChange = 0;
			nowEnemy.estimateVelocity = nowEnemy.velocity;
			nowEnemy.estimateHeading = nowEnemy.heading;
		} else {
			nowEnemy.headingChange = nowEnemy.heading - tempEnemy.heading;
			nowEnemy.energyChange = tempEnemy.energy - nowEnemy.energy;
			nowEnemy.velocityChange = nowEnemy.velocity - tempEnemy.velocity;
			nowEnemy.xChange = nowEnemy.x - tempEnemy.x;
			nowEnemy.yChange = nowEnemy.y - tempEnemy.y;
			nowEnemy.estimateVelocity = Math.max(Math.min(nowEnemy.velocity+4*nowEnemy.velocityChange,8),-8);
			nowEnemy.estimateHeading = nowEnemy.heading+4*nowEnemy.headingChange;
		}
		dIndex = (int)(nowEnemy.distance/DELTA_DISTANCE);
		enemyAverageVelocity = .96*enemyAverageVelocity + 0.04*nowEnemy.velocity;

		//other 	
		doMovement();
		doGun();
		doRadar();
		execute();
	}	
	
	public void onBulletHit(BulletHitEvent e){
		nowEnemy.energy = e.getEnergy();
	}
	
   	public void onHitByBullet(HitByBulletEvent e){
		nowEnemy.energy += e.getPower()*3d;
	}
	
	public void onHitRobot(HitRobotEvent e){
		nowEnemy.energy -= 0.6d;
	}
	
	public abstract void doMovement(); 
	
	public abstract void doGun(); 
	
	public abstract void doRadar();
	
}
