/*
 * Decompiled with CFR 0.152.
 */
package japs;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Serenity
extends AdvancedRobot {
    double margin;
    double destX;
    double destY;
    double minX;
    double minY;
    double maxX;
    double maxY;
    double prevX;
    double prevY;
    double oppEnergy;
    boolean accelerating;

    public void run() {
        this.prevX = 0.0;
        this.prevY = 0.0;
        this.minX = this.margin = 150.0;
        this.minY = this.margin;
        this.maxX = this.getBattleFieldWidth() - this.margin;
        this.maxY = this.getBattleFieldHeight() - this.margin;
        this.oppEnergy = 100.0;
        this.accelerating = true;
        this.newDestination();
        this.moveMe();
        while (true) {
            this.turnRadarRight(360.0);
            this.execute();
        }
    }

    public void newDestination() {
        this.destX = Math.random() * (this.maxX - this.minX) + this.minX;
        this.destY = Math.random() * (this.maxY - this.minY) + this.minY;
    }

    public void evade(double dangerAngle) {
        double evadeRadians = Math.random() < 0.5 ? (dangerAngle - (80.0 + Math.random() * 20.0)) / 180.0 * Math.PI : (dangerAngle + (80.0 + Math.random() * 20.0)) / 180.0 * Math.PI;
        this.destX = Math.sin(evadeRadians) * 200.0;
        this.destY = Math.cos(evadeRadians) * 200.0;
        if (this.destX < this.minX) {
            this.destX = this.minX;
        } else if (this.destX > this.maxX) {
            this.destX = this.maxX;
        }
        if (this.destY < this.minY) {
            this.destY = this.minY;
        } else if (this.destY > this.maxY) {
            this.destY = this.maxY;
        }
    }

    public void moveMe() {
        double curX = this.getX();
        double curY = this.getY();
        double curHeading = this.getHeading();
        double curVelocity = this.getVelocity();
        double speedDelta = Math.random() * (double)2;
        if (this.prevX != curX || this.prevY != curY) {
            this.out.println("(" + (int)curX + ',' + (int)curY + "), tick " + this.getTime());
            this.prevX = curX;
            this.prevY = curY;
        }
        if (Math.abs(curX - this.destX) < 50.0 && Math.abs(curY - this.destY) < 50.0) {
            this.newDestination();
        }
        double newHeading = Math.toDegrees(Math.atan2(this.destX - curX, this.destY - curY));
        this.setTurnAny(newHeading - curHeading);
        this.setAhead(300.0);
        this.setMaxVelocity((this.accelerating ? speedDelta : -speedDelta) + curVelocity);
        if (curVelocity > 7.0) {
            this.accelerating = false;
        } else if (curVelocity < (double)3) {
            this.accelerating = true;
        }
    }

    public void setTurnAny(double angle) {
        if ((angle = (angle + 720.0) % 360.0) > 180.0) {
            this.setTurnLeft(360.0 - angle);
        } else {
            this.setTurnRight(angle);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.evade(e.getHeading());
        this.setMaxVelocity(100.0);
        this.accelerating = true;
        this.moveMe();
        this.execute();
    }

    public void onHitWall(HitWallEvent e) {
        this.newDestination();
        this.moveMe();
        this.out.println("Huh? Een muur?");
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double newOpponentEnergy = e.getEnergy();
        double myHeading = this.getHeading();
        if (this.oppEnergy > newOpponentEnergy || e.getDistance() < 300.0) {
            this.evade(e.getHeading());
            this.setMaxVelocity(100.0);
            this.accelerating = true;
            this.moveMe();
            this.execute();
        }
        this.oppEnergy = newOpponentEnergy;
        this.moveMe();
    }

    public void onHitRobot(HitRobotEvent e) {
        double myHeading = this.getHeading();
        this.evade(e.getBearing() + myHeading);
        this.moveMe();
        this.execute();
    }

    private final /* synthetic */ void this() {
        this.margin = 150.0;
    }

    public Serenity() {
        this.this();
    }
}

