/*
 * Decompiled with CFR 0.152.
 */
package apc.radar;

import apc.Caan;
import apc.radar.Scan;
import apc.utils.HelperMethods;
import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.util.HashMap;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class Radar {
    private static final boolean ENABLE_DEBUGGING_GRAPHICS = true;
    private static final double MAX_RADAR_TRACKING_AMOUNT = 0.7853981633974483;
    private static final long BOT_NOT_FOUND = -1L;
    private static final double BOT_WIDTH = 36.0;
    private AdvancedRobot _robot;
    private HashMap<String, Scan> _scans;
    private Point2D.Double _myLocation;
    private String _targetName = null;
    private boolean _lockMode = false;
    private long _resetTime;
    private Point2D.Double _centerField;
    private int _radarDirection;
    private double _lastRadarHeading;
    private boolean _painting;
    private boolean _robocodePainting;
    private PrintStream _out;

    public Radar(Caan robot) {
        this._robot = robot;
        this._scans = new HashMap();
        this._centerField = new Point2D.Double(this._robot.getBattleFieldWidth() / 2.0, this._robot.getBattleFieldHeight() / 2.0);
        this._radarDirection = 1;
    }

    public void initRound(AdvancedRobot bot) {
        this._robot = bot;
        this._scans.clear();
        this._lockMode = false;
        this._resetTime = 0L;
        this._lastRadarHeading = this._robot.getRadarHeadingRadians();
    }

    public void execute() {
        this._myLocation = new Point2D.Double(this._robot.getX(), this._robot.getY());
        this.checkScansIntegrity();
        if (this._robot.getOthers() == 1 && !this._lockMode && !this._scans.isEmpty()) {
            this.setRadarLock((String)this._scans.keySet().toArray()[0]);
        }
        this.directRadar();
        this._lastRadarHeading = this._robot.getRadarHeadingRadians();
    }

    public void directRadar() {
        double radarTurnAmount;
        if (this._lockMode && !this._scans.containsKey(this._targetName)) {
            this._out.println("WARNING: Radar locked onto dead or non-existent bot, releasing lock.");
            this._lockMode = false;
        }
        if (this._lockMode && this._scans.get((Object)this._targetName).lastScanTime == this._robot.getTime()) {
            radarTurnAmount = Utils.normalRelativeAngle((double)(HelperMethods.absoluteBearing(this._myLocation, this._scans.get((Object)this._targetName).lastLocation) - this._robot.getRadarHeadingRadians()));
            this._radarDirection = HelperMethods.nonZeroSign(radarTurnAmount);
            radarTurnAmount += (double)this._radarDirection * 0.39269908169872414;
        } else {
            this._radarDirection = this.nextRadarDirection();
            radarTurnAmount = (double)this._radarDirection * 0.7853981633974483;
        }
        this._robot.setTurnRadarRightRadians(radarTurnAmount);
    }

    public void setRadarLock(String botName) {
        if (this._scans.containsKey(botName)) {
            this._targetName = botName;
            this._lockMode = true;
        }
    }

    public void releaseRadarLock() {
        this._lockMode = false;
    }

    public long minTicksToScan(String botName) {
        if (!this._scans.containsKey(botName)) {
            return -1L;
        }
        double absBearing = HelperMethods.absoluteBearing(this._myLocation, this._scans.get((Object)botName).lastLocation);
        double shortestAngleToScan = Math.abs(Utils.normalRelativeAngle((double)(absBearing - this._robot.getRadarHeadingRadians())));
        long minTicks = Math.round(Math.ceil(shortestAngleToScan / 0.7853981633974483));
        return minTicks;
    }

    private int nextRadarDirection() {
        if (this._scans.isEmpty() || this._scans.size() < this._robot.getOthers()) {
            return 1;
        }
        String stalestBot = this.findStalestBotName();
        Point2D.Double radarTarget = this.minTicksToScan(stalestBot) == 4L ? this._centerField : this._scans.get((Object)this.findStalestBotName()).lastLocation;
        double absBearingRadarTarget = HelperMethods.absoluteBearing(this._myLocation, radarTarget);
        if (Utils.normalRelativeAngle((double)(absBearingRadarTarget - this._robot.getRadarHeadingRadians())) > 0.0) {
            return 1;
        }
        return -1;
    }

    private String findStalestBotName() {
        long oldestTime = Long.MAX_VALUE;
        String botName = null;
        for (String name : this._scans.keySet()) {
            if (this._scans.get((Object)name).lastScanTime >= oldestTime) continue;
            oldestTime = this._scans.get((Object)name).lastScanTime;
            botName = name;
        }
        return botName;
    }

    private void checkScansIntegrity() {
        if (this._scans.size() != this._robot.getOthers() && this._robot.getTime() - this._resetTime > 25L && this._robot.getOthers() > 0) {
            this._scans.clear();
            this._lockMode = false;
            this._resetTime = this._robot.getTime();
        }
    }

    public void drawLastKnownBotLocations() {
        for (Scan scan : this._scans.values()) {
        }
    }

    public void paintOn() {
        this._painting = true;
    }

    public void paintOff() {
        this._painting = false;
    }

    public void robocodePaintOn() {
        this._robocodePainting = true;
    }

    public void robocodePaintOff() {
        this._robocodePainting = false;
    }

    public String paintLabel() {
        return "Radar";
    }

    public boolean paintStatus() {
        return this._painting && this._robocodePainting;
    }
}

