/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.stats;

import de.simpleworks.robocode.debug.Debug;
import de.simpleworks.robocode.stats.FiredBullet;
import de.simpleworks.robocode.stats.HitRatios;
import robocode.ScannedRobotEvent;

public class EnemyStat {
    private static final String NO_INIT = "not_initialized";
    private HitRatios FHitRatios = new HitRatios();
    private int FNumSamples = 0;
    private String FName = "not_initialized";
    private double FLastHeading = -1.0;
    private double FLastDistance = -1.0;
    private boolean FIsSentry = false;
    private double FLastVelocity = -1.0;
    private double FLastEnergy = -1.0;
    private double FAverageVelocity = -1.0;

    private void initStat(ScannedRobotEvent _sre) {
        this.updateLastValues(_sre);
        this.FNumSamples = 1;
        this.FName = _sre.getName();
        this.FIsSentry = _sre.isSentryRobot();
        this.FAverageVelocity = this.FLastVelocity;
    }

    private void updateLastValues(ScannedRobotEvent _sre) {
        this.FLastHeading = _sre.getHeading();
        this.FLastDistance = _sre.getDistance();
        this.FLastVelocity = _sre.getVelocity();
        this.FLastEnergy = _sre.getEnergy();
    }

    private void updateAverages(ScannedRobotEvent _SRE) {
        this.FAverageVelocity = (this.FAverageVelocity * (double)this.FNumSamples + _SRE.getVelocity()) / (double)(this.FNumSamples + 1);
        ++this.FNumSamples;
    }

    private boolean isInitialized() {
        return !this.FName.equals(NO_INIT);
    }

    public EnemyStat(ScannedRobotEvent _sre) {
        this.updateStat(_sre);
    }

    public void updateStat(ScannedRobotEvent _sre) {
        Debug.print(true, "Updating Stat on " + _sre.getName());
        if (this.isInitialized()) {
            this.updateLastValues(_sre);
            this.updateAverages(_sre);
        } else {
            this.initStat(_sre);
        }
    }

    public void updateHitRatio(FiredBullet _fb) {
        Debug.print(true, "Updating HitRatio on Bullet for" + _fb.getTarget());
        this.FHitRatios.updateStat(_fb);
    }

    public String getName() {
        return this.FName;
    }

    public double getLastHeading() {
        return this.FLastHeading;
    }

    public double getLastDistance() {
        return this.FLastDistance;
    }

    public boolean getIsSentry() {
        return this.FIsSentry;
    }

    public double getLastVelocity() {
        return this.FLastVelocity;
    }

    public double getLastEnergy() {
        return this.FLastEnergy;
    }

    public double getAverageVelocity() {
        return this.FAverageVelocity;
    }

    public int getShotsAt() {
        return this.FHitRatios.getTotalShots();
    }

    public int getBulltesHit() {
        return this.FHitRatios.getTotalHits();
    }

    public int getBulletsMissed() {
        return this.FHitRatios.getTotalMisses();
    }

    public double getHitRatio() {
        return this.FHitRatios.getTotalHitRatio();
    }

    public int getShotsAt(String _method) {
        return this.FHitRatios.getHitRatio(_method).getShotCount();
    }

    public int getBulltesHit(String _method) {
        return this.FHitRatios.getHitRatio(_method).getHitCount();
    }

    public int getBulletsMissed(String _method) {
        return this.FHitRatios.getHitRatio(_method).getMissedCount();
    }

    public double getHitRatio(String _method) {
        return this.FHitRatios.getHitRatio(_method).getHitRatio();
    }

    public String getPrefFireStrategy(int _anzKnownFS) {
        return this.FHitRatios.getPreferredMethod(_anzKnownFS);
    }
}

