/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws;

import java.awt.geom.Point2D;
import xander.core.drive.Direction;
import xander.core.math.RCMath;
import xander.core.track.Wave;

public class FactorArrays {
    public static double getPreciseFactorIndex(double factorAngle, int numFactors, double bulletVelocity, Direction surfDirection) {
        double mea = RCMath.getMaximumEscapeAngle(bulletVelocity);
        double rbfactor = factorAngle / mea * (double)surfDirection.getDirectionUnit();
        return RCMath.limit((double)numFactors / 2.0 + rbfactor * (double)numFactors / 2.0, 0.0, (double)numFactors - 0.001);
    }

    public static double getFactorAngle(double preciseFactorIndex, int numFactors, double bulletVelocity, Direction surfDirection) {
        double mea = RCMath.getMaximumEscapeAngle(bulletVelocity);
        double rbfactor = (preciseFactorIndex - (double)numFactors / 2.0) / ((double)numFactors / 2.0);
        return mea * rbfactor / (double)surfDirection.getDirectionUnit();
    }

    public static double getFactorAngle(Wave bulletWave, Point2D.Double currentDefenderLocation) {
        double zeroAngle = RCMath.getRobocodeAngle(bulletWave.getOrigin(), bulletWave.getInitialDefenderSnapshot().getLocation());
        double currentAngle = RCMath.getRobocodeAngle(bulletWave.getOrigin(), currentDefenderLocation);
        return RCMath.getTurnAngle(zeroAngle, currentAngle);
    }

    public static double getFactorAngle(Wave bulletWave, double robocodeAngleDegrees) {
        double zeroAngle = RCMath.getRobocodeAngle(bulletWave.getOrigin(), bulletWave.getInitialDefenderSnapshot().getLocation());
        return RCMath.getTurnAngle(zeroAngle, robocodeAngleDegrees);
    }

    public static int getFactorIndex(double preciseFactorIndex) {
        return (int)Math.round(Math.floor(preciseFactorIndex));
    }

    public static int getFactorIndex(double factorAngle, int numFactors, double bulletVelocity, Direction surfDirection) {
        double preciseIndex = FactorArrays.getPreciseFactorIndex(factorAngle, numFactors, bulletVelocity, surfDirection);
        return FactorArrays.getFactorIndex(preciseIndex);
    }

    public static double getPreciseFactorIndexRobotWidth(int numFactors, double distance, double bulletVelocity) {
        double circ = Math.PI * 2 * distance;
        double bodyWidthDegrees = 14400.0 / circ;
        return FactorArrays.getPreciseFactorIndex(bodyWidthDegrees, numFactors, bulletVelocity, Direction.CLOCKWISE) - (double)numFactors / 2.0;
    }

    public static double getLoad(double[] array, double weight) {
        return FactorArrays.getLoad(array, weight, 0, array.length - 1);
    }

    public static double getLoad(double[] array, double weight, int beginIndex, int endIndex) {
        double sum = 0.0;
        int i = beginIndex;
        while (i <= endIndex) {
            sum += array[i];
            ++i;
        }
        return sum / weight;
    }

    public static int getMostWeightedFactorIndex(double[] array, int beginFactorIndex, int endFactorIndex) {
        int bestFactorIndex = -1;
        double bestFactorValue = Double.NEGATIVE_INFINITY;
        int tieCount = 0;
        boolean runningTie = false;
        int i = beginFactorIndex;
        while (i <= endFactorIndex) {
            if (array[i] > bestFactorValue) {
                bestFactorValue = array[i];
                bestFactorIndex = i;
                tieCount = 0;
                runningTie = true;
            } else if (runningTie && array[i] == bestFactorValue) {
                ++tieCount;
            } else {
                runningTie = false;
            }
            ++i;
        }
        return bestFactorIndex + tieCount / 2;
    }

    public static double getMostWeightedFactorAngle(double[] array, int factorIndex, double bulletVelocity, Direction surfDirection) {
        double sum;
        double mea = RCMath.getMaximumEscapeAngle(bulletVelocity);
        double divisionSize = mea * 2.0 / (double)array.length;
        double rbf = ((double)factorIndex - (double)array.length / 2.0) / ((double)array.length / 2.0);
        double divCenter = mea * (rbf / (double)surfDirection.getDirectionUnit());
        double d0 = 0.0;
        double d1 = array[factorIndex];
        double d2 = 0.0;
        if (factorIndex > 0) {
            d0 = array[factorIndex - 1];
        }
        if (factorIndex < array.length - 1) {
            d2 = array[factorIndex + 1];
        }
        if ((sum = d0 + d1 + d2) == 0.0) {
            return divCenter;
        }
        return divCenter - d0 / sum * divisionSize + d2 / sum * divisionSize;
    }

    public static double getLeastWeightedFactorAngle(double[] array, int factorIndex, double bulletVelocity, Direction surfDirection) {
        double sum;
        double mea = RCMath.getMaximumEscapeAngle(bulletVelocity);
        double rbf = ((double)factorIndex - (double)array.length / 2.0) / ((double)array.length / 2.0);
        double divCenter = mea * (rbf / (double)surfDirection.getDirectionUnit());
        double divisionSize = mea * 2.0 / (double)array.length;
        double d0 = 0.0;
        double d1 = array[factorIndex];
        double d2 = 0.0;
        if (factorIndex > 0) {
            d0 = array[factorIndex - 1];
        }
        if (factorIndex < array.length - 1) {
            d2 = array[factorIndex + 1];
        }
        if ((sum = d0 + d1 + d2) == 0.0) {
            return divCenter;
        }
        return divCenter - (1.0 - d0 / sum) * divisionSize + (1.0 - d2 / sum) * divisionSize;
    }

    public static double getDistanceDangerMultiplier(double distance, double flatDistance, double criticalDistance) {
        return distance < flatDistance ? Math.pow((flatDistance - criticalDistance) / (Math.max(distance, criticalDistance + 0.1) - criticalDistance), 2.0) : 1.0;
    }
}

