/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.robot;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class GreenDragon
extends AdvancedRobot {
    private static int SHOOTING_POWER = 2;
    double direction = 1.0;
    double scanDirection = 45.0;
    Location enemyLocation = null;
    Location myLocation = null;
    Location shootingTarget = null;
    ArrayList<Location> enemyLocationHistory = new ArrayList();

    public void onHitWall(HitWallEvent event) {
        this.direction = -this.direction;
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.myLocation = new Location(this.getX(), this.getY());
        this.enemyLocation = Geometry.getLocationAtBearing(this.myLocation, event.getBearing() + this.getHeading(), event.getDistance());
        this.scanDirection = -this.scanDirection;
        this.enemyLocationHistory.add(this.enemyLocation);
        this.shootingTarget = this.enemyLocation;
        if (this.getOthers() == 1) {
            int timeUntilHit = (int)Math.round(Geometry.getDistanceBetweenLocations(this.myLocation, this.enemyLocation) / Rules.getBulletSpeed((double)SHOOTING_POWER));
            double predictedDistanceMoved = event.getVelocity() * (double)timeUntilHit;
            double predictedHeading = event.getHeading();
            if (this.enemyLocationHistory.size() > timeUntilHit) {
                Location oldLocation = this.enemyLocationHistory.get(this.enemyLocationHistory.size() - timeUntilHit);
                predictedDistanceMoved = Geometry.getDistanceBetweenLocations(this.enemyLocation, oldLocation);
                predictedHeading = Geometry.getBearingBetweenLocations(oldLocation, this.enemyLocation);
                Location prediction = Geometry.getLocationAtBearing(this.enemyLocation, predictedHeading, predictedDistanceMoved);
                if (prediction.isOnBattlefield()) {
                    this.shootingTarget = prediction;
                }
            }
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        this.direction = -this.direction;
    }

    private double scoreLocation(Location location) {
        return Geometry.getDistanceBetweenLocations(location, this.enemyLocation) - Geometry.getDistanceBetweenLocations(this.myLocation, location);
    }

    private void chooseMovementTarget() {
        Location bestLocation = new Location(this.getBattleFieldWidth() - this.enemyLocation.getX(), this.getBattleFieldHeight() - this.enemyLocation.getY());
        double bearing = Geometry.getBearingBetweenLocations(this.myLocation, bestLocation);
        if (this.direction < 0.0) {
            bearing += 180.0;
        }
        this.setTurnRight(Geometry.getRelativeBearing(this.getHeading(), bearing));
        this.setAhead(this.direction * 100.0);
    }

    public void run() {
        this.setBattleConstants();
        this.setAdjustGunForRobotTurn(true);
        this.setAllColors(Color.GREEN);
        while (true) {
            this.myLocation = new Location(this.getX(), this.getY());
            if (this.enemyLocation != null) {
                this.setTurnGunRight(Geometry.getRelativeBearing(this.getGunHeading(), Geometry.getBearingBetweenLocations(this.myLocation, this.shootingTarget)));
                if (this.getDistanceRemaining() == 0.0) {
                    this.chooseMovementTarget();
                }
            }
            this.setTurnRadarLeft(this.scanDirection);
            if (this.getTurnRemaining() == 0.0) {
                this.setTurnRight(Math.random() * 90.0 - 45.0);
            }
            this.setFire(2.0);
            this.execute();
        }
    }

    private void setBattleConstants() {
        BattleConstants.getInstance().setBattlefieldHeight(this.getBattleFieldHeight());
        BattleConstants.getInstance().setBattlefieldWidth(this.getBattleFieldWidth());
        BattleConstants.getInstance().setRobotHeight(this.getHeight());
        BattleConstants.getInstance().setRobotWidth(this.getWidth());
        BattleConstants.getInstance().setGunCoolingRate(this.getGunCoolingRate());
    }
}

