/*
 * Decompiled with CFR 0.152.
 */
package jcs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Coord {
    private double x;
    private double y;
    private final double DEFAULT_TOLERANCE = 10.0;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setXY(double _x, double _y) {
        this.setX(_x);
        this.setY(_y);
    }

    public Coord getCoordFromScan(double enemyBearing, double enemyDistance) {
        double _y;
        double _x;
        if (enemyBearing <= 1.5707963267948966) {
            _x = this.x + enemyDistance * Math.sin(enemyBearing);
            _y = this.y + enemyDistance * Math.cos(enemyBearing);
        }
        if (enemyBearing <= Math.PI && enemyBearing > 1.5707963267948966) {
            _x = this.x + enemyDistance * Math.sin(Math.PI - enemyBearing);
            _y = this.y - enemyDistance * Math.cos(Math.PI - enemyBearing);
        }
        if (enemyBearing > Math.PI && enemyBearing <= 4.71238898038469) {
            _x = this.x - enemyDistance * Math.sin(enemyBearing - Math.PI);
            _y = this.y - enemyDistance * Math.cos(enemyBearing - Math.PI);
        } else {
            _x = this.x - enemyDistance * Math.sin(Math.PI * 2 - enemyBearing);
            _y = this.y + enemyDistance * Math.cos(Math.PI * 2 - enemyBearing);
        }
        Coord out = new Coord(_x, _y);
        return out;
    }

    public boolean equals(Coord in) {
        boolean answer = false;
        if (Math.abs(in.getX() - this.x) < 10.0 && Math.abs(in.getY() - this.y) < 10.0) {
            answer = true;
        }
        return answer;
    }

    public String toString() {
        return new String("(" + this.x + ',' + this.y + ')');
    }

    public double calcHeading(Coord _target) {
        double hyp = this.calcDist(_target);
        double x = _target.getX() - this.getX();
        double y = _target.getY() - this.getY();
        double heading = x > 0.0 && y > 0.0 ? Math.abs(Math.asin(x / hyp)) : (x > 0.0 && y < 0.0 ? 1.5707963267948966 + Math.abs(Math.asin(y / hyp)) : (x < 0.0 && y < 0.0 ? Math.PI + Math.abs(Math.asin(x / hyp)) : 4.71238898038469 + Math.abs(Math.asin(y / hyp))));
        return heading;
    }

    public double calcDist(Coord _target) {
        double dist = 0.0;
        double x = this.getX() - _target.getX();
        double y = this.getY() - _target.getY();
        dist = Math.sqrt(x * x + y * y);
        return dist;
    }

    public Coord minus(Coord _coord) {
        return new Coord(_coord.getX() - this.x, _coord.getY() - this.y);
    }

    public Coord plus(Coord _coord) {
        return new Coord(_coord.getX() + this.x, _coord.getY() + this.y);
    }

    private final /* synthetic */ void this() {
        this.DEFAULT_TOLERANCE = 10.0;
    }

    public Coord() {
        this.this();
        this.x = 0.0;
        this.y = 0.0;
    }

    public Coord(double x, double y) {
        this.this();
        this.x = x;
        this.y = y;
    }

    public Coord(Coord in) {
        this.this();
        this.x = in.getX();
        this.y = in.getY();
    }
}

