/*
 * Decompiled with CFR 0.152.
 */
package wcsv.melee;

import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import wcsv.melee.BasicInfo;
import wcsv.melee.Utils;

public class Info {
    public BasicInfo basic;
    public double bearing;
    public double distance;
    public double lateralDir;

    public void update(ScannedRobotEvent scan, TeamRobot observer) {
        this.basic.update(scan, observer);
        this.bearing = Utils.absoluteAngle((observer.getHeadingRadians() + scan.getBearingRadians()) % (Math.PI * 2));
        this.distance = scan.getDistance();
        this.lateralDir = this.orbitalDirection();
    }

    public void update(BasicInfo robotInfo, ScannedRobotEvent observer) {
        this.basic = robotInfo;
        this.bearing = Utils.absoluteAngle((robotInfo.heading + observer.getBearingRadians()) % (Math.PI * 2) - Math.PI);
        this.distance = observer.getDistance();
        this.lateralDir = this.orbitalDirection();
    }

    public double orbitalDirection() {
        int s = Utils.sign(this.lateralVelocity());
        if (s != 0) {
            return s;
        }
        if (this.lateralDir == 0.0) {
            return 1.0;
        }
        return this.lateralDir;
    }

    public double lateralVelocity() {
        return Math.sin(this.basic.heading - this.bearing) * this.basic.velocity;
    }

    public double advancingVelocity() {
        return -Math.cos(this.basic.heading - this.bearing) * this.basic.velocity;
    }

    public Info(ScannedRobotEvent scan, TeamRobot observer) {
        this.basic = new BasicInfo(scan, observer);
        this.bearing = Utils.absoluteAngle((observer.getHeadingRadians() + scan.getBearingRadians()) % (Math.PI * 2));
        this.distance = scan.getDistance();
        this.lateralDir = this.orbitalDirection();
    }

    public Info(BasicInfo robotInfo, ScannedRobotEvent observer) {
        this.basic = robotInfo;
        this.bearing = Utils.absoluteAngle((robotInfo.heading + observer.getBearingRadians()) % (Math.PI * 2) - Math.PI);
        this.distance = observer.getDistance();
        this.lateralDir = this.orbitalDirection();
    }

    public Info(Info info) {
        this.basic = new BasicInfo(info.basic);
        this.bearing = info.bearing;
        this.distance = info.distance;
        this.lateralDir = info.lateralDir;
    }
}

