/*
 * Decompiled with CFR 0.152.
 */
package jje;

public class Coordinate {
    private final double EQUALITY_THRESHOLD = 2.0;
    public double x;
    public double y;
    public boolean linearIntercept;

    public Coordinate() {
        this.set(0.0, 0.0);
    }

    public Coordinate(double posX, double posY) {
        this.set(posX, posY);
    }

    public Coordinate(Coordinate coord) {
        this.set(coord.x, coord.y);
    }

    public boolean isEqualTo(Coordinate coordinate) {
        return Math.abs(this.x - coordinate.x) < 2.0 && Math.abs(this.y - coordinate.y) < 2.0;
    }

    public void set(double posX, double posY) {
        this.x = posX;
        this.y = posY;
    }

    public void set(Coordinate coordinate) {
        this.set(coordinate.x, coordinate.y);
    }

    public Coordinate minus(Coordinate coordinate) {
        return new Coordinate(this.x - coordinate.x, this.y - coordinate.y);
    }

    public Coordinate plus(Coordinate coordinate) {
        return new Coordinate(this.x + coordinate.x, this.y + coordinate.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double distanceFrom(Coordinate coordinate) {
        return this.minus(coordinate).length();
    }

    public Coordinate unit() {
        return new Coordinate(this.x / this.length(), this.y / this.length());
    }

    public Coordinate multiply(double multiplier) {
        return new Coordinate(this.x * multiplier, this.y * multiplier);
    }

    public double distanceFrom(Coordinate pos0, Coordinate pos1) {
        Coordinate difference = pos1.minus(pos0);
        Coordinate u = difference.unit();
        Coordinate x = this.minus(pos0);
        double d = x.dotProduct(u);
        if (d <= 0.0) {
            return this.distanceFrom(pos0);
        }
        if (d >= difference.length()) {
            return this.distanceFrom(pos1);
        }
        Coordinate projectionPoint = pos0.plus(u.multiply(d));
        return this.distanceFrom(projectionPoint);
    }

    public double dotProduct(Coordinate coordinate) {
        return this.x * coordinate.x + this.y * coordinate.y;
    }

    public Coordinate getNextPosition(double nextHeading, double nextVelocity, double angularVelocity) {
        double dX = nextVelocity * Math.sin(Math.toRadians(nextHeading + angularVelocity));
        double dY = nextVelocity * Math.cos(Math.toRadians(nextHeading + angularVelocity));
        return new Coordinate(this.x + dX, this.y + dY);
    }

    public double headingTo(Coordinate targetCoordinate) {
        Coordinate difference = targetCoordinate.minus(this);
        return Math.toDegrees(Math.atan2(difference.x, difference.y));
    }

    public Coordinate rotate(double angle_deg) {
        double angle_rad = -Math.toRadians(angle_deg);
        return new Coordinate(this.x * Math.cos(angle_rad) - this.y * Math.sin(angle_rad), this.x * Math.sin(angle_rad) + this.y * Math.cos(angle_rad));
    }
}

