/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.util.Random;
import starpkg.BattleArea;
import starpkg.MoveData;
import starpkg.MoveDataList;
import starpkg.Position;
import starpkg.Rect;
import starpkg.StarViewerZ;

public class MoveCtrl {
    StarViewerZ robot = null;
    BattleArea battleArea = null;
    MoveDataList moveDataList = new MoveDataList();
    private final double DEFAULT_VELOCITY = 8.0;
    public double moveDirection = 1.0;
    public double turnDirection = 1.0;
    public double facingDirection = 1.0;
    public double aheadDistance = 100.0;
    public double turnAngle = 360.0;
    public final long DEFAULT_MOVEBSET_CTRL = 60L;
    public long moveBestCtrl = 60L;
    public final long DEFAULT_MOVEAWAY_CTRL = 4L;
    public long moveAwayCtrl = 4L;
    public long moveAwayTime = 0L;
    public int moveAwayCounter = 0;
    public double moveAwayDist = 220.0;
    public boolean stopCheckWall = false;
    public long stopCheckWallTime = 0L;
    public long checkBestPosTime = 0L;
    public int curBestPos = 8;
    public final int MAX_MOVEAWAY_ARRAY = 10;
    public double[] moveAwayArray = new double[10];
    public int moveAwayPtr = 0;
    public long hitWallTimeOut = 0L;
    public int stopCounter = 0;
    public long stopTime = 0L;
    public long checkNearWallTime = 0L;
    private int RAND_STRAIGHTMOVE_REDIR = 15;
    private int straightMoveArryPointer = 0;
    public long straightMoveReDirTime = 0L;
    private long straightMoveTurnTime = 0L;
    public long straightMoveReDirCtrl = 30L;
    public long straightMoveTurnCtrl = 3L;
    private int straightMoveCounter = 0;
    private int straightMoveMax = 6;
    private long facingMoveEnemyTime = 0L;
    public long facingMoveEnemyCtrl = 10L;
    public int moveModeUsing = 3;
    public MoveData curMoveData = null;
    public boolean moveStop = false;
    public boolean turnMoveStart = false;
    public long turnMoveTimeCtrl = 10L;
    public long turnMoveTime = 0L;
    public double turnMoveTurnDir = 1.0;
    private final long DEFAULT_POINTMOVE_CTRL = 80L;
    private Position curPoint = new Position();
    public boolean pointMoveStart = false;
    public long pointMoveTime = 0L;
    public long pointMoveCtrl = 80L;
    private Rect pointRect = new Rect();
    private Rect chkPointRect = new Rect();
    private double pointMoveTurnSpeed = 8.0;
    public boolean pointForward = true;
    public int nearWallCounter;

    public MoveCtrl(StarViewerZ getRobot) {
        this.robot = getRobot;
        this.battleArea = this.robot.battleArea;
        this.SetMoveAwayDistList();
        this.moveAwayDist = this.moveAwayArray[0];
    }

    public void Move() {
        if (this.robot.status.totalEnemy > 1) {
            if (this.robot.getTime() > 15L) {
                this.robot.shootAnalyser.MoreEnemyTimeCheck();
                this.MoreMove();
            }
        } else if (this.robot.getTime() > 15L) {
            this.SnakeMove();
        }
    }

    public void MoreMove() {
        if (this.checkBestPosTime == 0L) {
            if (this.robot.status.totalEnemy > 3) {
                this.MoveToBestCorner();
            } else {
                this.MoveToBestCorner();
            }
        }
        if (this.robot.getTime() - this.checkBestPosTime > this.moveBestCtrl) {
            this.moveBestCtrl = this.robot.status.totalEnemy < 5 ? 45L : 60L;
            if (this.robot.status.totalEnemy < 11) {
                this.MoreMoveBestPoint();
            }
            this.moveAwayCtrl = 10L;
            this.checkBestPosTime = this.robot.getTime();
        }
        if (this.robot.getTime() - this.moveAwayTime > this.moveAwayCtrl) {
            this.moveAwayCtrl = 4L;
            int enemyNearMe = this.robot.enemy.CheckEnemyNearMe(this.moveAwayDist);
            double moveAwayCounterMax = 20.0;
            int myPos = this.robot.battleArea.CheckInPosArea(new Position(this.robot.getX(), this.robot.getY()));
            if (myPos == 0 || myPos == 3 || myPos == 12 || myPos == 15) {
                moveAwayCounterMax = 13.0;
            }
            if (enemyNearMe > 0) {
                this.robot.setMaxVelocity(8.0);
                Position safePoint = this.robot.enemy.GetSafePos(this.moveAwayDist, new Position(this.robot.getX(), this.robot.getY()));
                if (safePoint.X != -1000.0 && safePoint.Y != -1000.0) {
                    this.PointMoveStart(safePoint, 7.0);
                }
                ++this.moveAwayCounter;
                if ((double)this.moveAwayCounter >= moveAwayCounterMax) {
                    this.moveAwayCounter = 0;
                    this.moveAwayCtrl = 8L;
                    this.robot.out.println("TimeOut");
                }
            } else {
                this.moveAwayCounter = 0;
            }
            this.moveAwayTime = this.robot.getTime();
        }
        if (this.pointMoveStart) {
            if (this.robot.getTime() % 5L == 0L) {
                this.PointMove();
            }
            this.TurnMove();
            if (!this.stopCheckWall) {
                if (this.CheckNearWall()) {
                    this.PointMoveStop();
                    this.moveAwayCtrl = 30L;
                } else if (this.robot.enemy.CheckRectEnemyInside(this.chkPointRect)) {
                    this.PointMoveStop();
                }
            } else if (this.robot.getTime() - this.stopCheckWallTime > 20L) {
                this.stopCheckWall = false;
            }
            this.robot.setTurnRight(this.turnAngle * this.turnDirection);
            this.robot.setAhead(this.aheadDistance * this.moveDirection);
        } else {
            this.SnakeMove();
        }
    }

    public void StopMoreMoveCheckWall() {
        this.stopCheckWallTime = this.robot.getTime();
        this.stopCheckWall = true;
    }

    public void MoveToBestCorner() {
        Position cPos = new Position(this.robot.getX(), this.robot.getY());
        int myPosArea = this.battleArea.CheckInPosArea(cPos);
        int bestPosID = this.robot.enemy.GetBestCornerId(myPosArea);
        this.moveAwayCtrl = 20L;
        this.PointMoveStart(this.robot.battleArea.PosAreaPos[bestPosID], 8.0);
        this.robot.out.println(bestPosID);
    }

    public void MoreMoveBestPoint() {
        int myPosArea = -1;
        int bestPosID = -1;
        Position cPos = new Position(this.robot.getX(), this.robot.getY());
        myPosArea = this.battleArea.CheckInPosArea(cPos);
        if (myPosArea != (bestPosID = this.robot.enemy.GetBestAreaId(myPosArea))) {
            this.PointMoveStart(this.robot.battleArea.PosAreaPos[bestPosID], 7.0);
        }
    }

    public void SetMoveAwayDistList() {
        this.moveAwayArray[0] = 350.0;
        this.moveAwayArray[1] = 350.0;
        this.moveAwayArray[2] = 350.0;
        this.moveAwayArray[3] = 350.0;
        this.moveAwayArray[4] = 350.0;
        this.moveAwayArray[5] = 350.0;
        this.moveAwayArray[6] = 360.0;
        this.moveAwayArray[7] = 400.0;
        this.moveAwayArray[8] = 500.0;
        this.moveAwayArray[9] = 600.0;
    }

    public void AddMoveAwayDist() {
        if (this.robot.status.totalEnemy >= 10) {
            this.moveAwayDist = this.moveAwayArray[0];
        } else {
            if (this.moveAwayPtr >= 10) {
                this.moveAwayPtr = 9;
            }
            this.moveAwayDist = this.moveAwayArray[this.moveAwayPtr];
        }
    }

    public void SnakeMove() {
        boolean nearWall = false;
        if (this.robot.status.totalEnemy > 1) {
            this.checkNearWallTime = 0L;
        }
        if (this.robot.getTime() - this.checkNearWallTime > 3L && (nearWall = this.CheckNearWall())) {
            if (this.moveDataList.nearWallAdj[this.moveModeUsing] != 0.0) {
                this.straightMoveReDirTime = (long)((double)this.robot.getTime() + this.moveDataList.nearWallAdj[this.moveModeUsing]);
            }
            if (this.robot.getTime() - this.hitWallTimeOut > 30L) {
                this.robot.turnRight(20.0);
                this.hitWallTimeOut = this.robot.getTime();
            }
            this.robot.shootAnalyser.stopTurnTime = this.robot.getTime();
            this.moveStop = false;
            this.checkNearWallTime = this.robot.getTime();
        }
        if (!nearWall) {
            if (this.turnMoveStart) {
                this.TurnMove();
            } else {
                if (this.robot.status.totalEnemy > 1) {
                    if (this.robot.status.totalEnemy > 3) {
                        if (this.robot.enemy.enemyMain.distance >= 150.0) {
                            this.moveModeUsing = 9;
                        } else if (this.robot.enemy.enemyMain.distance < 150.0) {
                            this.moveModeUsing = 8;
                        }
                    } else {
                        this.moveModeUsing = this.robot.status.totalEnemy > 1 ? 8 : 10;
                    }
                } else {
                    this.moveModeUsing = this.robot.enemy.enemyMain.distance < 1000.0 ? 0 : 1;
                }
                this.StraightMove();
            }
            this.hitWallTimeOut = this.robot.getTime();
        }
        this.robot.setTurnRight(this.turnAngle * this.turnDirection);
        if (!this.moveStop) {
            this.robot.setAhead(this.aheadDistance * this.moveDirection);
            this.stopTime = this.robot.getTime();
        }
    }

    public void StraightMove() {
        if (this.curMoveData == null) {
            this.curMoveData = this.moveDataList.GetCurrentMove(this.moveModeUsing);
        }
        while (this.curMoveData.reDirTime == 1000L) {
            this.curMoveData = this.moveDataList.GetCurrentMove(this.moveModeUsing);
        }
        if (this.robot.getTime() - this.straightMoveReDirTime > this.curMoveData.reDirTime && this.curMoveData.reDirTime != 0L) {
            this.moveStop = false;
            if (this.curMoveData.useReDir) {
                this.moveDirection *= -1.0;
            }
            this.straightMoveReDirTime = this.robot.getTime();
            if (this.curMoveData.moveMode == 1.0 || this.curMoveData.moveMode == 2.0) {
                long tTime = 5L;
                double tDir = 1.0;
                double trunSpeed = 5.0;
                this.CheckFacingEnemy();
                if (this.facingDirection < 0.0) {
                    tTime = (long)((double)tTime + Math.abs(this.robot.enemy.enemyMain.bearing_deg - 90.0) / 4.0);
                    tDir = this.moveDirection < 0.0 ? -1.0 : 1.0;
                } else {
                    tTime = (long)((double)tTime + Math.abs(this.robot.enemy.enemyMain.bearing_deg + 90.0) / 4.0);
                    tDir = this.moveDirection < 0.0 ? 1.0 : -1.0;
                }
                if (this.curMoveData.moveMode == 2.0) {
                    tDir *= -1.0;
                    tTime = (long)((double)tTime * 0.8);
                    trunSpeed = 7.0;
                } else {
                    tTime = (long)((double)tTime * 0.9);
                }
                if (this.curMoveData.reDirTime == 1L) {
                    tTime = (long)((double)tTime * 0.6);
                }
                if (this.curMoveData.reDirTime == 2L) {
                    tTime = (long)((double)tTime * 0.8);
                }
                this.TurnMoveStart(tTime, tDir, trunSpeed);
            } else if (this.curMoveData.turnDir != 0.0) {
                this.TurnMoveStart(this.curMoveData.turnTime, this.curMoveData.turnDir, this.curMoveData.turnSpeed);
            }
            this.curMoveData = this.moveDataList.GetCurrentMove(this.moveModeUsing);
        }
        if (this.curMoveData.useFacingMove && this.robot.getTime() - this.facingMoveEnemyTime >= this.facingMoveEnemyCtrl) {
            double facingAngle = this.GetFacingEnemyAngle();
            if (facingAngle < 0.0) {
                if (Math.abs(facingAngle) > 10.0) {
                    this.TurnMoveStart(4L, -1.0 * this.facingDirection, 8.0);
                } else {
                    this.TurnMoveStart(2L, -1.0 * this.facingDirection, 8.0);
                }
            } else if (Math.abs(facingAngle) > 10.0) {
                this.TurnMoveStart(4L, 1.0 * this.facingDirection, 8.0);
            } else {
                this.TurnMoveStart(2L, 1.0 * this.facingDirection, 8.0);
            }
        }
        if (this.robot.getTime() - this.straightMoveTurnTime > this.straightMoveTurnCtrl) {
            this.turnDirection *= -1.0;
            this.straightMoveTurnTime = this.robot.getTime();
        }
    }

    public void MoreMoveOnHit() {
        this.pointMoveTime -= 10L;
    }

    public void CheckFacingEnemy() {
        this.facingDirection = this.robot.enemy.enemyMain.bearing_deg < 0.0 ? 1.0 : -1.0;
    }

    public double GetFacingEnemyAngle() {
        if (this.robot.enemy.enemyMain.bearing_deg < 0.0) {
            this.facingDirection = 1.0;
            return 90.0 + this.robot.enemy.enemyMain.bearing_deg;
        }
        this.facingDirection = -1.0;
        return 90.0 - this.robot.enemy.enemyMain.bearing_deg;
    }

    public void TurnMoveStart(long turnTime, double straightMoveReDirCtrl, double velocity) {
        this.turnMoveStart = true;
        this.turnMoveTime = this.robot.getTime();
        this.robot.setMaxVelocity(velocity);
        this.turnMoveTurnDir = straightMoveReDirCtrl > 0.0 ? 1.0 : -1.0;
        this.turnMoveTimeCtrl = turnTime;
    }

    public void TurnMove() {
        if (this.turnMoveTurnDir < 0.0) {
            this.turnDirection = -1.0;
        } else if (this.turnMoveTurnDir > 0.0) {
            this.turnDirection = 1.0;
        }
        if (this.robot.getTime() - this.turnMoveTime > this.turnMoveTimeCtrl) {
            this.turnMoveStart = false;
            this.robot.setMaxVelocity(8.0);
        }
    }

    public void PointMoveStart(Position toPos, double turnSpeed) {
        this.curPoint = new Position(toPos);
        this.pointRect = new Rect(new Position(this.curPoint.X - 40.0, this.curPoint.Y - 40.0), new Position(this.curPoint.X + 40.0, this.curPoint.Y + 40.0));
        this.chkPointRect = new Rect(new Position(this.curPoint.X - 100.0, this.curPoint.Y - 100.0), new Position(this.curPoint.X + 100.0, this.curPoint.Y + 100.0));
        this.pointMoveTurnSpeed = turnSpeed;
        this.pointMoveTime = this.robot.getTime();
        this.pointMoveStart = true;
        this.turnMoveStart = false;
        Position cPos = new Position(this.robot.getX(), this.robot.getY());
        double head = this.robot.getHeading();
        double pointAngle = cPos.DegreeTo(this.curPoint);
        if (pointAngle < 0.0) {
            pointAngle += 360.0;
        }
        this.pointForward = (pointAngle = this.robot.tools.NormalAngle(head - pointAngle)) < 0.0 ? pointAngle > -90.0 : pointAngle < 90.0;
    }

    public void PointMove() {
        Position cPos = new Position(this.robot.getX(), this.robot.getY());
        double head = this.robot.getHeading();
        double pointAngle = cPos.DegreeTo(this.curPoint);
        if (pointAngle < 0.0) {
            pointAngle += 360.0;
        }
        pointAngle = this.robot.tools.NormalAngle(head - pointAngle);
        if (this.pointForward) {
            double turnDir = pointAngle < 0.0 ? -1.0 : 1.0;
            this.moveDirection = 1.0;
            if (pointAngle < -5.0 && pointAngle > 5.0) {
                this.TurnMoveStart(1L, turnDir, this.pointMoveTurnSpeed);
            } else {
                this.TurnMoveStart(1L, turnDir, 8.0);
            }
        } else {
            double turnDir = pointAngle < 0.0 ? 1.0 : -1.0;
            this.moveDirection = -1.0;
            if (pointAngle < -175.0 || pointAngle > 175.0) {
                this.TurnMoveStart(1L, turnDir, 8.0);
            } else {
                this.TurnMoveStart(1L, turnDir, this.pointMoveTurnSpeed);
            }
        }
        if (this.pointRect.PointInside(cPos)) {
            this.PointMoveStop();
        }
        if (this.robot.getTime() - this.pointMoveTime > this.pointMoveCtrl) {
            this.PointMoveStop();
        }
    }

    public void PointMoveStop() {
        this.pointMoveCtrl = 80L;
        this.pointMoveStart = false;
    }

    public boolean CheckNearWall() {
        Position cPos = new Position(this.robot.getX(), this.robot.getY());
        double heading = this.robot.getHeading();
        double turnDir = 1.0;
        if (!this.robot.battleArea.mainArea.PointInside(cPos)) {
            if (this.NearWallLeft(cPos.X)) {
                if (heading > 180.0 && heading < 360.0) {
                    this.moveDirection = -1.0;
                    if (heading > 270.0) {
                        turnDir = -1.0;
                    }
                } else if (heading > 0.0 && heading < 180.0) {
                    this.moveDirection = 1.0;
                    if (heading > 90.0) {
                        turnDir = -1.0;
                    }
                }
                this.TurnMoveStart(2L, turnDir, 8.0);
                return true;
            }
            if (this.NearWallTop(cPos.Y)) {
                if (heading > 90.0 && heading < 270.0) {
                    this.moveDirection = 1.0;
                    if (heading > 180.0) {
                        turnDir *= -1.0;
                    }
                } else if (heading < 90.0 || heading > 270.0) {
                    this.moveDirection = -1.0;
                    if (heading > 0.0 && heading < 90.0) {
                        turnDir *= -1.0;
                    }
                }
                this.TurnMoveStart(2L, turnDir, 8.0);
                return true;
            }
            if (this.NearWallRight(cPos.X)) {
                if (heading > 0.0 && heading < 180.0) {
                    this.moveDirection = -1.0;
                    if (heading > 90.0) {
                        turnDir = -1.0;
                    }
                } else if (heading > 180.0 && heading < 360.0) {
                    this.moveDirection = 1.0;
                    if (heading > 270.0 && heading < 360.0) {
                        turnDir = -1.0;
                    }
                }
                this.TurnMoveStart(2L, turnDir, 8.0);
                return true;
            }
            if (this.NearWallBottom(cPos.Y)) {
                if (heading > 90.0 && heading < 270.0) {
                    this.moveDirection = -1.0;
                    if (heading > 180.0) {
                        turnDir = -1.0;
                    }
                } else if (heading < 90.0 || heading > 270.0) {
                    this.moveDirection = 1.0;
                    if (heading > 0.0 && heading < 90.0) {
                        turnDir = -1.0;
                    }
                }
                this.TurnMoveStart(2L, turnDir, 8.0);
                return true;
            }
        }
        return false;
    }

    public boolean NearWallLeft(double x) {
        return x < this.robot.battleArea.mainArea.pos1.X;
    }

    public boolean NearWallTop(double y) {
        return y > this.robot.battleArea.mainArea.pos2.Y;
    }

    public boolean NearWallRight(double x) {
        return x > this.robot.battleArea.mainArea.pos2.X;
    }

    public boolean NearWallBottom(double y) {
        return y < this.robot.battleArea.mainArea.pos1.Y;
    }

    public int RandIntNum(int range) {
        return Math.abs(new Random().nextInt() % range);
    }
}

