/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice;

import ahr.ice.AHRBot;
import ahr.ice.CircularGun;
import ahr.ice.Gun;
import ahr.ice.HeadOnGun;
import ahr.ice.InfinityGun;
import ahr.ice.LinearGun;
import ahr.ice.LinearIterativeGun;
import ahr.ice.Math.Enemy;
import ahr.ice.Math.math;
import ahr.ice.RobotState;
import ahr.ice.VirtualBullet;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import robocode.annotation.SafeStatic;

public class VirtualGuns {
    @SafeStatic
    public static AHRBot r;
    public static double lastEnemyVelocity;
    public static double lateralDirection;
    public static Vector enemyGuns;
    public static int counter;
    public static int enemyShootCounter;

    public static void owner(AHRBot ar) {
        r = ar;
    }

    public static void gun() {
        if (VirtualGuns.r.isShooting) {
            if (enemyGuns.size() < 1) {
                enemyGuns = new Vector();
                enemyGuns.add(new LinearGun());
                enemyGuns.add(new CircularGun());
                enemyGuns.add(new HeadOnGun());
                enemyGuns.add(new InfinityGun());
                enemyGuns.add(new LinearIterativeGun());
            }
            double firepower = AHRBot.firepower;
            long bestScore = -1L;
            Gun bestGun = null;
            for (Gun gun : AHRBot.guns) {
                if (gun.hits <= bestScore) continue;
                bestScore = gun.hits;
                bestGun = gun;
                AHRBot.bestGun = AHRBot.guns.indexOf(bestGun);
            }
            if (r.getGunHeat() < 0.5) {
                r.setTurnGunRightRadians(math.normalizeRelativeAngle(bestGun.getFiringAngle(AHRBot.me, AHRBot.target, firepower, AHRBot.battlefield) - r.getGunHeadingRadians()));
            }
            ++counter;
            long time = r.getTime();
            Enemy en = AHRBot.setupEnemy(AHRBot.target.name);
            Enumeration e = AHRBot.targets.elements();
            RobotState oT = AHRBot.target;
            for (int j = 0; j < 5; ++j) {
                for (Gun gun : AHRBot.guns) {
                    VirtualBullet newVirtualBullet = new VirtualBullet();
                    newVirtualBullet.heading = gun.getFiringAngle(r.myState(), AHRBot.target, firepower, AHRBot.battlefield);
                    newVirtualBullet.setLocation(r.position());
                    newVirtualBullet.velocity = 20.0 - 3.0 * firepower;
                    newVirtualBullet.gunUsed = gun;
                    newVirtualBullet.shooter = "me";
                    newVirtualBullet.target = en;
                    newVirtualBullet.lastUpdate = time;
                    newVirtualBullet.real = r.setFireBullet(firepower) != null ? 10 : 1;
                    AHRBot.virtualBullets.add(newVirtualBullet);
                }
            }
        }
    }

    public static void enemyFire(double power, Enemy enem) {
        long time = r.getTime();
        if (++enemyShootCounter % 1 == 0) {
            RobotState t = new RobotState();
            t.setLocation(enem.x, enem.y);
            t.heading = enem.heading;
            t.velocity = enem.speed;
            t.name = enem.name;
            for (Gun gun : enemyGuns) {
                VirtualBullet newVirtualBullet = new VirtualBullet();
                newVirtualBullet.heading = gun.getFiringAngle(t, r.myState(), power, AHRBot.battlefield);
                newVirtualBullet.setLocation(AHRBot.target);
                newVirtualBullet.velocity = 20.0 - 3.0 * power;
                newVirtualBullet.gunUsed = gun;
                newVirtualBullet.shooter = enem.name;
                newVirtualBullet.lastUpdate = time;
                Enemy enm = AHRBot.setupEnemy("me");
                enm.coords = r.position();
                enm.name = "me";
                newVirtualBullet.target = enm;
                AHRBot.virtualBullets.add(newVirtualBullet);
            }
        }
    }

    public static void holdFire() {
        VirtualGuns.r.isShooting = false;
    }

    public static void fireAtWill() {
        VirtualGuns.r.isShooting = true;
    }

    public static void moveBullets(Rectangle2D.Double battlefield) {
        boolean turnDirection = true;
        long time = r.getTime();
        Iterator i = AHRBot.virtualBullets.iterator();
        while (i.hasNext()) {
            VirtualBullet virtualBullet = (VirtualBullet)i.next();
            virtualBullet.setLocation(virtualBullet.x + Math.sin(virtualBullet.heading) * virtualBullet.velocity * (double)(time - virtualBullet.lastUpdate), virtualBullet.y + Math.cos(virtualBullet.heading) * virtualBullet.velocity * (double)(time - virtualBullet.lastUpdate));
            Enemy en = virtualBullet.target;
            Point2D.Double t = en.coords;
            if (virtualBullet.distance(t) < 25.0 && virtualBullet.shooter.equals("me")) {
                virtualBullet.gunUsed.hits += (long)virtualBullet.real;
                i.remove();
            } else if (!battlefield.contains(virtualBullet)) {
                i.remove();
            }
            virtualBullet.lastUpdate = time;
        }
    }

    static {
        lastEnemyVelocity = 0.0;
        lateralDirection = 1.0;
        enemyGuns = new Vector();
        counter = 0;
        enemyShootCounter = 0;
    }
}

